/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.modules.unittest.Bundle;
import org.eclipse.ease.modules.unittest.ITestSetFilter;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public class TestSuite
extends TestComposite {
    private final TestSuiteModel fTestModel;
    private boolean fTerminated = false;
    private final Map<String, TestFile> fTestFiles = new HashMap<String, TestFile>();
    private int fCurrentTestCount;
    private List<TestFile> fActiveTestFiles = Collections.emptyList();
    private OutputStream fOutputStream = System.out;
    private OutputStream fErrorStream = System.err;
    private InputStream fInputStream = System.in;
    private Map<String, Object> fSetupVariables;
    private ILaunch fDebugLaunch;

    public static String getExceptionMessage(Throwable exception) {
        String message = exception.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            message = exception.getMessage();
        }
        if (message == null || message.isEmpty()) {
            message = exception.getClass().getName();
            message = String.valueOf(message) + " (" + exception.getStackTrace()[0].toString() + ")";
        }
        return message;
    }

    public TestSuite(TestSuiteModel model) {
        super(null);
        this.fTestModel = model;
        for (String location : this.fTestModel.getTestFiles()) {
            this.fTestFiles.put(location, new TestFile(this, location));
        }
    }

    public TestSuite(IFile file) throws IOException, CoreException {
        this(new TestSuiteModel(file));
    }

    protected void finalize() throws Throwable {
        this.fTestModel.close();
        super.finalize();
    }

    private String getCodeFragment(String name) {
        return this.fTestModel.getCodeFragment(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Object testObject, TestStatus status) {
        super.notify(testObject, status);
        if (testObject instanceof TestFile && status != TestStatus.RUNNING) {
            --this.fCurrentTestCount;
            boolean stopOnFailure = this.fTestModel.getFlag("stop suite on failure", false);
            if (stopOnFailure && status == TestStatus.FAILURE) {
                this.terminate();
            } else {
                TestSuite testSuite = this;
                synchronized (testSuite) {
                    this.notifyAll();
                }
            }
        }
    }

    public Collection<TestFile> getChildren() {
        return this.fTestFiles.values();
    }

    public void run() {
        this.run(ITestSetFilter.ALL);
    }

    public void run(ITestSetFilter filter) {
        this.fActiveTestFiles = new LinkedList<TestFile>();
        for (TestFile testFile : this.fTestFiles.values()) {
            if (!filter.matches(testFile)) continue;
            this.fActiveTestFiles.add(testFile);
        }
        Collections.sort(this.fActiveTestFiles);
        if (!this.fActiveTestFiles.isEmpty()) {
            new TestSuiteJob("Testsuite " + this.toString()).schedule();
        } else {
            this.setStatus(TestStatus.PASS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        this.fTerminated = true;
        TestSuite testSuite = this;
        synchronized (testSuite) {
            this.notifyAll();
        }
    }

    public TestSuiteModel getModel() {
        return this.fTestModel;
    }

    public int getActiveTestCount() {
        return this.fActiveTestFiles.size();
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            this.fOutputStream = outputStream;
        }
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public OutputStream getErrorStream() {
        return this.fErrorStream;
    }

    public void setErrorStream(InputStream inputStream) {
        if (inputStream != null) {
            this.fInputStream = inputStream;
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public List<TestFile> getActiveTestFiles() {
        return new ArrayList<TestFile>(this.fActiveTestFiles);
    }

    public void setErrorStream(OutputStream errorStream) {
        if (errorStream != null) {
            this.fErrorStream = errorStream;
        }
    }

    public IScriptEngine createScriptEngine() {
        IScriptService scriptService = ScriptService.getService();
        if (this.fDebugLaunch != null) {
            ILaunchConfiguration configuration = this.fDebugLaunch.getLaunchConfiguration();
            String engineID = "";
            try {
                engineID = configuration.getAttribute("Script engine", "");
            }
            catch (CoreException coreException) {}
            IScriptEngine engine = scriptService.getEngineByID(engineID).createEngine();
            if (engine instanceof IDebugEngine) {
                boolean suspendOnStartup = false;
                try {
                    suspendOnStartup = configuration.getAttribute("Suspend on startup", false);
                }
                catch (CoreException coreException) {}
                boolean suspendOnScriptLoad = false;
                try {
                    suspendOnScriptLoad = configuration.getAttribute("Suspend on script load", false);
                }
                catch (CoreException coreException) {}
                boolean showDynamicCode = false;
                try {
                    showDynamicCode = configuration.getAttribute("Display dynamic code", false);
                }
                catch (CoreException coreException) {}
                ((IDebugEngine)engine).setupDebugger(this.fDebugLaunch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
            }
            return engine;
        }
        return scriptService.getEngineByID("org.eclipse.ease.javascript.rhinoDebugger").createEngine();
    }

    @Override
    public void reset() {
        this.fTerminated = false;
        try {
            this.fTestModel.getFile().deleteMarkers("org.eclipse.ease.modules.unittest.scriptassertion", false, 0);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        if (this.fTestModel.isDirty()) {
            try {
                this.fTestModel.reload();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            for (String location : this.fTestModel.getTestFiles()) {
                if (this.fTestFiles.containsKey(location)) continue;
                this.fTestFiles.put(location, new TestFile(this, location));
            }
            this.fTestFiles.keySet().retainAll(this.fTestModel.getTestFiles());
        }
        super.reset();
    }

    Map<String, Object> getVariables() {
        return this.fSetupVariables;
    }

    public void setDebugOptions(ILaunch launch) {
        this.fDebugLaunch = launch;
    }

    @Override
    public Object getFile() {
        return this.getModel().getFile();
    }

    static /* synthetic */ List access$0(TestSuite testSuite) {
        return testSuite.fActiveTestFiles;
    }

    static /* synthetic */ void access$1(TestSuite testSuite, int n) {
        testSuite.fCurrentTestCount = n;
    }

    static /* synthetic */ TestSuiteModel access$2(TestSuite testSuite) {
        return testSuite.fTestModel;
    }

    static /* synthetic */ void access$3(TestSuite testSuite, Map map) {
        testSuite.fSetupVariables = map;
    }

    static /* synthetic */ boolean access$4(TestSuite testSuite) {
        return testSuite.fTerminated;
    }

    static /* synthetic */ int access$5(TestSuite testSuite) {
        return testSuite.fCurrentTestCount;
    }

    private class TestSuiteJob
    extends Job {
        public TestSuiteJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            block40: {
                block38: {
                    block39: {
                        block36: {
                            block37: {
                                TestSuite.this.reset();
                                TestSuite.this.setStatus(TestStatus.RUNNING);
                                for (TestFile file : TestSuite.access$0(TestSuite.this)) {
                                    file.reset();
                                }
                                TestSuite.this.setScriptEngine(TestSuite.this.createScriptEngine());
                                TestSuite.this.getScriptEngine().addExecutionListener((IExecutionListener)TestSuite.this);
                                TestSuite.this.getScriptEngine().setTerminateOnIdle(false);
                                TestSuite.this.getScriptEngine().setOutputStream(TestSuite.this.getOutputStream());
                                TestSuite.this.getScriptEngine().setErrorStream(TestSuite.this.getErrorStream());
                                TestSuite.this.getScriptEngine().setVariable("__FAIL_ON_ERROR", (Object)TestSuite.this.getModel().getFlag("promote errors to failures", false));
                                TestSuite.this.getScriptEngine().setVariable("__internal_testObject", (Object)TestSuite.this);
                                TestSuite.this.getScriptEngine().executeAsync((Object)"loadModule('Unittest')");
                                TestSuite.this.getScriptEngine().schedule();
                                TestSuite.access$1(TestSuite.this, 0);
                                variablesCode = new StringBuffer();
                                for (TestSuiteModel.Variable var : TestSuite.access$2(TestSuite.this).getVariables()) {
                                    variablesCode.append(var.getName()).append(" = ").append(var.getContent()).append(Bundle.LINE_DELIMITER);
                                }
                                if (this.runCode("Variable definitions", variablesCode.toString(), monitor)) break block36;
                                var9_5 = Status.OK_STATUS;
                                if (!TestSuite.this.getModel().getFlag("execute teardown on failure", true)) break block37;
                                try {
                                    this.runCodeFragment("TestSuite Teardown", monitor);
                                }
                                catch (InterruptedException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            for (Test test : TestSuite.this.getTests()) {
                                test.setStatus(TestStatus.PASS);
                            }
                            TestSuite.this.getScriptEngine().terminate();
                            TestSuite.this.setScriptEngine(null);
                            TestSuite.this.setStatus(TestStatus.PASS);
                            return var9_5;
                        }
                        if (this.runCodeFragment("TestSuite Setup", monitor)) break block38;
                        var9_6 = Status.OK_STATUS;
                        if (!TestSuite.this.getModel().getFlag("execute teardown on failure", true)) break block39;
                        try {
                            this.runCodeFragment("TestSuite Teardown", monitor);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    for (Test test : TestSuite.this.getTests()) {
                        test.setStatus(TestStatus.PASS);
                    }
                    TestSuite.this.getScriptEngine().terminate();
                    TestSuite.this.setScriptEngine(null);
                    TestSuite.this.setStatus(TestStatus.PASS);
                    return var9_6;
                }
                try {
                    try {
                        TestSuite.access$3(TestSuite.this, TestSuite.this.getScriptEngine().getVariables());
                        launchedTestFiles = new ArrayList<TestFile>();
                        filesUnderTest = new ArrayList<E>(TestSuite.access$0(TestSuite.this));
                        var5_23 = TestSuite.this;
                        synchronized (var5_23) {
                            while (!(TestSuite.access$4(TestSuite.this) || TestSuite.access$5(TestSuite.this) <= 0 && filesUnderTest.isEmpty())) {
                                maxSimultaneousThreads = Math.max(1, TestSuite.access$2(TestSuite.this).getFlag("max threads", 1));
                                if (!filesUnderTest.isEmpty() && TestSuite.access$5(TestSuite.this) < maxSimultaneousThreads) {
                                    testFile = (TestFile)filesUnderTest.remove(0);
                                    launchedTestFiles.add(testFile);
                                    testFile.addTestListener(TestSuite.this);
                                    v0 = TestSuite.this;
                                    TestSuite.access$1(v0, TestSuite.access$5(v0) + 1);
                                    testFile.execute();
                                    continue;
                                }
                                TestSuite.this.wait();
                            }
                        }
                        if (!TestSuite.access$4(TestSuite.this)) break block40;
                        for (TestFile testFile : launchedTestFiles) {
                            testFile.terminate();
                        }
                        var5_23 = TestSuite.this;
                        synchronized (var5_23) {
                            while (TestSuite.access$5(TestSuite.this) > 0) {
                                TestSuite.this.wait();
                            }
                            break block40;
                        }
                    }
                    catch (InterruptedException v3) {
                        var9_7 = Status.CANCEL_STATUS;
                        if (TestSuite.this.getModel().getFlag("execute teardown on failure", true)) {
                            try {
                                this.runCodeFragment("TestSuite Teardown", monitor);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ** for (test : TestSuite.this.getTests())
                    }
                }
                catch (Throwable var8_27) {
                    if (TestSuite.this.getModel().getFlag("execute teardown on failure", true)) {
                        try {
                            this.runCodeFragment("TestSuite Teardown", monitor);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ** for (test : TestSuite.this.getTests())
                }
lbl-1000:
                // 1 sources

                {
                    test.setStatus(TestStatus.PASS);
                    continue;
                }
lbl109:
                // 1 sources

                TestSuite.this.getScriptEngine().terminate();
                TestSuite.this.setScriptEngine(null);
                TestSuite.this.setStatus(TestStatus.PASS);
                return var9_7;
lbl-1000:
                // 1 sources

                {
                    test.setStatus(TestStatus.PASS);
                    continue;
                }
lbl124:
                // 1 sources

                TestSuite.this.getScriptEngine().terminate();
                TestSuite.this.setScriptEngine(null);
                TestSuite.this.setStatus(TestStatus.PASS);
                throw var8_27;
            }
            if (TestSuite.this.getModel().getFlag("execute teardown on failure", true)) {
                try {
                    this.runCodeFragment("TestSuite Teardown", monitor);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            for (Test test : TestSuite.this.getTests()) {
                test.setStatus(TestStatus.PASS);
            }
            TestSuite.this.getScriptEngine().terminate();
            TestSuite.this.setScriptEngine(null);
            TestSuite.this.setStatus(TestStatus.PASS);
            return Status.OK_STATUS;
        }

        private boolean runCodeFragment(String fragmentID, IProgressMonitor monitor) throws InterruptedException {
            return this.runCode(fragmentID, TestSuite.this.getCodeFragment(fragmentID), monitor);
        }

        private boolean runCode(String identifier, String code, IProgressMonitor monitor) throws InterruptedException {
            if (code != null && !code.trim().isEmpty()) {
                TestSuite.this.addTest(new Test((TestComposite)TestSuite.this, "[" + identifier + "]", true));
                ScriptResult result = TestSuite.this.getScriptEngine().executeSync((Object)code);
                if (result.hasException()) {
                    ArrayList<IScriptDebugFrame> trace = new ArrayList<IScriptDebugFrame>();
                    trace.add((IScriptDebugFrame)new ScriptDebugFrame(new Script("[" + identifier + "]", (Object)""), 0, 1));
                    TestSuite.this.addTestResult(TestStatus.FAILURE, TestSuite.getExceptionMessage(result.getException()), trace);
                    TestSuite.this.endTest();
                    return false;
                }
                TestSuite.this.endTest();
            }
            return true;
        }
    }
}

