/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ui.PlatformUI;

public class ResourceDropHandler
implements IShellDropHandler {
    @Override
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        if (element instanceof IFile || element instanceof File || element instanceof URI) {
            return scriptEngine.getDescription().getSupportedScriptTypes().contains(ResourceDropHandler.getScriptType(element));
        }
        return false;
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        scriptEngine.executeAsync(element);
    }

    private static ScriptType getScriptType(Object element) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        return scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)element, null));
    }
}

