/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.dnd.ISourceDndInteractionEvent;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.XmlDiscoverySelectionTransferSetter;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.internal.xml.ICollectionTransformer;
import org.jmock.core.Constraint;

public class XmlDiscoverySelectionTransferSetterTest
extends MockObjectTestCase {
    private Mock<ILongOperationRunner> opRunner;
    private Mock<ICollectionTransformer> transformer;
    private IStructuredSelection selection;
    private Object selectedObject;
    private XmlDiscoverySelectionTransferSetter setter;

    protected void setUp() throws Exception {
        this.opRunner = this.mock(ILongOperationRunner.class);
        this.transformer = this.mock(ICollectionTransformer.class);
        this.selectedObject = new Object();
        this.selection = new StructuredSelection(this.selectedObject);
        this.setter = new XmlDiscoverySelectionTransferSetter((ILongOperationRunner)this.opRunner.proxy()){

            protected ICollectionTransformer createTransformer() {
                return (ICollectionTransformer)XmlDiscoverySelectionTransferSetterTest.this.transformer.proxy();
            }
        };
    }

    public void testSetData() {
        Mock event = this.mock(ISourceDndInteractionEvent.class);
        this.transformer.expects(this.once()).method("setCollectionTag").with((Constraint)this.eq("discovery-selection"));
        this.transformer.expects(this.once()).method("setItemTag").with((Constraint)this.eq("selection-item"));
        this.transformer.expects(this.once()).method("setNamespace").with((Constraint)this.eq("http://eclipse.org/platform.discovery"));
        this.transformer.expects(this.once()).method("transform").with(this.iteratorConstraint(this.selectedObject), (Constraint)this.eq(this.opRunner.proxy())).will(this.returnValue("Test data"));
        event.expects(this.once()).method("setData").with((Constraint)this.eq("Test data"));
        this.setter.setData(this.selection, (ISourceDndInteractionEvent)event.proxy());
    }

    private Constraint iteratorConstraint(final Object ... expectedObjects) {
        return new Constraint(){

            public boolean eval(Object arg0) {
                Iterator it = (Iterator)arg0;
                ArrayList selectedObjects = new ArrayList();
                while (it.hasNext()) {
                    selectedObjects.add(it.next());
                }
                boolean result = selectedObjects.size() == expectedObjects.length && selectedObjects.containsAll(Arrays.asList(expectedObjects));
                return result;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        };
    }
}

