/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleSelectionProvider;

public class SearchConsoleSelectionProviderTest
extends TestCase {
    private ISelectionChangedListener selectionListener;
    private SearchConsoleSelectionProvider selProvider;
    private ISelection selection;
    private SearchConsoleSelectionProvider.IViewCustomizationsObtainer custObtainer;
    private IGenericViewCustomization viewCustomization;
    private List<IGenericViewCustomization> allCustomizations;

    protected void setUp() throws Exception {
        this.selectionListener = (ISelectionChangedListener)EasyMock.createMock(ISelectionChangedListener.class);
        this.viewCustomization = (IGenericViewCustomization)EasyMock.createMock(IGenericViewCustomization.class);
        this.custObtainer = (SearchConsoleSelectionProvider.IViewCustomizationsObtainer)EasyMock.createMock(SearchConsoleSelectionProvider.IViewCustomizationsObtainer.class);
        this.allCustomizations = new ArrayList<IGenericViewCustomization>();
        EasyMock.expect((Object)this.custObtainer.viewCustomizations()).andStubReturn(this.allCustomizations);
        EasyMock.replay((Object[])new Object[]{this.custObtainer});
        this.selProvider = new SearchConsoleSelectionProvider(this.custObtainer);
        this.selection = (ISelection)EasyMock.createMock(ISelection.class);
    }

    public void testRegisterSelListener() {
        this.selectionListener.selectionChanged(this.selChangedEventExpectation(this.selection));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.selectionListener});
        this.selProvider.addSelectionChangedListener(this.selectionListener);
        this.selProvider.setSelection(this.selection);
        EasyMock.verify((Object[])new Object[]{this.selectionListener});
    }

    public SelectionChangedEvent selChangedEventExpectation(final ISelection expectedSelection) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
            }

            public boolean matches(Object argument) {
                SelectionChangedEvent event = (SelectionChangedEvent)argument;
                return event.getSelection().equals(expectedSelection);
            }
        });
        return null;
    }

    public void testUnregisterSelListener() {
        EasyMock.replay((Object[])new Object[]{this.selectionListener});
        this.selProvider.addSelectionChangedListener(this.selectionListener);
        this.selProvider.removeSelectionChangedListener(this.selectionListener);
        this.selProvider.setSelection(this.selection);
        EasyMock.verify((Object[])new Object[]{this.selectionListener});
    }

    public void testMultiThreadAccess() throws InterruptedException {
        boolean[] continueExecution_1 = new boolean[1];
        final boolean[] listenerIsWorking_1 = new boolean[1];
        boolean[] continueExecution_2 = new boolean[1];
        final boolean[] listenerIsWorking_2 = new boolean[1];
        final boolean[] modificationStarted = new boolean[1];
        final ISelectionChangedListener listener_1 = this.blockingListner(continueExecution_1, listenerIsWorking_1);
        this.selProvider.addSelectionChangedListener(listener_1);
        final ISelectionChangedListener listener_2 = this.blockingListner(continueExecution_2, listenerIsWorking_2);
        this.selProvider.addSelectionChangedListener(listener_2);
        Thread notifyingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SearchConsoleSelectionProviderTest.this.selProvider.setSelection((ISelection)new StructuredSelection());
            }
        });
        notifyingThread.setName("Listener notifying thread");
        notifyingThread.setDaemon(true);
        Thread modifyingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!listenerIsWorking_1[0] && !listenerIsWorking_2[0]) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                modificationStarted[0] = true;
                SearchConsoleSelectionProviderTest.this.selProvider.removeSelectionChangedListener(listener_1);
                SearchConsoleSelectionProviderTest.this.selProvider.removeSelectionChangedListener(listener_2);
            }
        });
        modifyingThread.setName("Listener modifying thread");
        modifyingThread.setDaemon(true);
        final String[] failMsg = new String[1];
        Thread.UncaughtExceptionHandler excHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                failMsg[0] = "Thread " + t.getName() + " threw uncaught exception: " + e.getMessage();
            }
        };
        notifyingThread.setUncaughtExceptionHandler(excHandler);
        modifyingThread.setUncaughtExceptionHandler(excHandler);
        notifyingThread.start();
        modifyingThread.start();
        while (!modificationStarted[0]) {
            Thread.sleep(50L);
        }
        continueExecution_1[0] = true;
        continueExecution_2[0] = true;
        modifyingThread.join();
        notifyingThread.join();
        if (failMsg[0] != null) {
            SearchConsoleSelectionProviderTest.fail((String)failMsg[0]);
        }
    }

    public void testSetSelectionNotifiesCustomizations() {
        this.viewCustomization.selectionChanged((ISelection)EasyMock.eq((Object)this.selection));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.viewCustomization});
        this.allCustomizations.add(this.viewCustomization);
        this.selProvider.setSelection(this.selection);
        EasyMock.verify((Object[])new Object[]{this.viewCustomization});
    }

    private ISelectionChangedListener blockingListner(final boolean[] continueExecutionFlag, final boolean[] listenerIsWorkingFlag) {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                listenerIsWorkingFlag[0] = true;
                while (!continueExecutionFlag[0]) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }
}

