/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.api.impl.GenericViewCustomizationImpl;
import org.eclipse.platform.discovery.ui.internal.view.favorites.FavoritesContentProvider;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.jmock.core.Constraint;

public class FavoritesContentProviderTest
extends MockObjectTestCase {
    private FavoritesContentProvider testedProvider;
    private ISearchFavoritesViewCustomization viewCust;
    private Mock<ITreeContentProvider> contentProvider;
    private Mock<ILogger> logger;
    private Object favoritesGroup_1;
    private Object favoritesGroup_2;
    private Object favoritesItem_1;
    private Object favoritesItem_2;
    private Object favoritesItem_3;
    private Object favoritesItem_1_Child;
    private Object favoritesItem_2_Child;
    private Object favoritesItem_3_Child;

    protected void setUp() throws Exception {
        this.favoritesGroup_1 = new Object();
        this.favoritesGroup_2 = new Object();
        this.favoritesItem_1 = new Object();
        this.favoritesItem_2 = new Object();
        this.favoritesItem_3 = new Object();
        this.favoritesItem_1_Child = new Object();
        this.favoritesItem_2_Child = new Object();
        this.favoritesItem_3_Child = new Object();
        this.contentProvider = this.mock(ITreeContentProvider.class);
        this.contentProvider.expects(this.never()).method("inputChanged");
        this.logger = this.mock(ILogger.class);
        this.setupViewCustomization();
        this.testedProvider = new FavoritesContentProvider(Arrays.asList(this.viewCust)){

            protected ILogger logger() {
                return (ILogger)FavoritesContentProviderTest.this.logger.proxy();
            }
        };
    }

    private void setupViewCustomization() {
        this.viewCust = new TestCustomization();
    }

    public void testSetInputAndGetElements() {
        this.testedProvider.inputChanged(null, null, new HashSet<Object>(Arrays.asList(this.favoritesItem_1, this.favoritesItem_2, this.favoritesItem_3)));
        HashSet<Object> groups = new HashSet<Object>(Arrays.asList(this.testedProvider.getElements(null)));
        FavoritesContentProviderTest.assertEquals((String)"Two elements expected", (int)2, (int)groups.size());
        FavoritesContentProviderTest.assertTrue((String)"Group1 not found", (boolean)groups.contains(this.favoritesGroup_1));
        FavoritesContentProviderTest.assertTrue((String)"Group2 not found", (boolean)groups.contains(this.favoritesGroup_2));
    }

    public void testSetNullInput() {
        this.testSetInputAndGetElements();
        this.testedProvider.inputChanged(null, null, null);
        FavoritesContentProviderTest.assertEquals((String)"No elements expected", (int)0, (int)this.testedProvider.getElements(null).length);
    }

    public void testGetChildren() {
        this.contentProvider.expects(this.once()).method("getChildren").with((Constraint)this.eq(this.favoritesItem_1)).will(this.returnValue(new Object[]{this.favoritesItem_1_Child}));
        this.contentProvider.expects(this.once()).method("getChildren").with((Constraint)this.eq(this.favoritesItem_2)).will(this.returnValue(new Object[]{this.favoritesItem_2_Child}));
        this.contentProvider.expects(this.once()).method("getChildren").with((Constraint)this.eq(this.favoritesItem_3)).will(this.returnValue(new Object[]{this.favoritesItem_3_Child}));
        this.testedProvider.inputChanged(null, null, new HashSet<Object>(Arrays.asList(this.favoritesItem_1, this.favoritesItem_2, this.favoritesItem_3)));
        HashSet<Object> children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesGroup_1)));
        FavoritesContentProviderTest.assertEquals((String)"Two children expected", (int)2, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Item1 not found", (boolean)children.contains(this.favoritesItem_1));
        FavoritesContentProviderTest.assertTrue((String)"Item2 not found", (boolean)children.contains(this.favoritesItem_2));
        children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesGroup_2)));
        FavoritesContentProviderTest.assertEquals((String)"One childr expected", (int)1, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Item2 not found", (boolean)children.contains(this.favoritesItem_3));
        children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesItem_1)));
        FavoritesContentProviderTest.assertEquals((String)"One child expected", (int)1, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Unexpected favorites1 child", (children.iterator().next() == this.favoritesItem_1_Child ? 1 : 0) != 0);
        children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesItem_2)));
        FavoritesContentProviderTest.assertEquals((String)"One child expected", (int)1, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Unexpected favorites2 child", (children.iterator().next() == this.favoritesItem_2_Child ? 1 : 0) != 0);
        children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesItem_3)));
        FavoritesContentProviderTest.assertEquals((String)"One child expected", (int)1, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Unexpected favorites3 child", (children.iterator().next() == this.favoritesItem_3_Child ? 1 : 0) != 0);
    }

    public void testInputChange() {
        this.testGetChildren();
        this.contentProvider.reset();
        this.contentProvider.expects(this.once()).method("getChildren").with((Constraint)this.eq(this.favoritesItem_1)).will(this.returnValue(new Object[]{this.favoritesItem_1_Child}));
        this.testedProvider.inputChanged(null, null, new HashSet<Object>(Arrays.asList(this.favoritesItem_1, this.favoritesItem_2)));
        HashSet<Object> groups = new HashSet<Object>(Arrays.asList(this.testedProvider.getElements(null)));
        FavoritesContentProviderTest.assertEquals((String)"One elements expected", (int)1, (int)groups.size());
        FavoritesContentProviderTest.assertTrue((String)"Group1 not found", (boolean)groups.contains(this.favoritesGroup_1));
        HashSet<Object> children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesGroup_1)));
        FavoritesContentProviderTest.assertEquals((String)"Two children expected", (int)2, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Item1 not found", (boolean)children.contains(this.favoritesItem_1));
        FavoritesContentProviderTest.assertTrue((String)"Item2 not found", (boolean)children.contains(this.favoritesItem_2));
        children = new HashSet<Object>(Arrays.asList(this.testedProvider.getChildren(this.favoritesItem_1)));
        FavoritesContentProviderTest.assertEquals((String)"One child expected", (int)1, (int)children.size());
        FavoritesContentProviderTest.assertTrue((String)"Unexpected favorites1 child", (children.iterator().next() == this.favoritesItem_1_Child ? 1 : 0) != 0);
    }

    public void testHasChildren() {
        this.contentProvider.expects(this.once()).method("hasChildren").with((Constraint)this.eq(this.favoritesItem_1)).will(this.returnValue(true));
        this.contentProvider.expects(this.once()).method("hasChildren").with((Constraint)this.eq(this.favoritesItem_2)).will(this.returnValue(true));
        this.testedProvider.inputChanged(null, null, new HashSet<Object>(Arrays.asList(this.favoritesItem_1, this.favoritesItem_2, this.favoritesItem_3)));
        FavoritesContentProviderTest.assertTrue((String)"Children expected for group1", (boolean)this.testedProvider.hasChildren(this.favoritesGroup_1));
        FavoritesContentProviderTest.assertTrue((String)"Children expected for group1", (boolean)this.testedProvider.hasChildren(this.favoritesGroup_2));
        FavoritesContentProviderTest.assertTrue((String)"Children expected for item1", (boolean)this.testedProvider.hasChildren(this.favoritesItem_1));
        FavoritesContentProviderTest.assertTrue((String)"Children not expected for item2", (boolean)this.testedProvider.hasChildren(this.favoritesItem_2));
    }

    public void testWithFavoriteItemWithoutGroup() {
        this.viewCust = new TestCustomization(this){

            @Override
            public Object itemGroup(Object arg0) {
                if (arg0 == favoritesItem_1) {
                    return null;
                }
                throw new IllegalArgumentException("Unexpected favorites item");
            }
        };
        this.testedProvider = new FavoritesContentProvider(Arrays.asList(this.viewCust)){

            protected ILogger logger() {
                return (ILogger)FavoritesContentProviderTest.this.logger.proxy();
            }
        };
        this.logger.expects(this.once()).method("logWarn");
        this.testedProvider.inputChanged(null, null, new HashSet<Object>(Arrays.asList(this.favoritesItem_1)));
        FavoritesContentProviderTest.assertEquals((String)"No element expected", (int)0, (int)this.testedProvider.getElements(null).length);
    }

    private class TestCustomization
    extends GenericViewCustomizationImpl
    implements ISearchFavoritesViewCustomization {
        private TestCustomization() {
        }

        public Object itemGroup(Object item) {
            if (item == FavoritesContentProviderTest.this.favoritesItem_1 || item == FavoritesContentProviderTest.this.favoritesItem_2) {
                return FavoritesContentProviderTest.this.favoritesGroup_1;
            }
            if (item == FavoritesContentProviderTest.this.favoritesItem_3) {
                return FavoritesContentProviderTest.this.favoritesGroup_2;
            }
            throw new IllegalArgumentException("Unexpected favorites item");
        }

        public Set<Object> itemsFor(Object itemsSource) {
            return new HashSet<Object>(Arrays.asList(itemsSource));
        }

        public ITreeContentProvider getContentProvider() {
            return (ITreeContentProvider)FavoritesContentProviderTest.this.contentProvider.proxy();
        }

        /* synthetic */ TestCustomization(TestCustomization testCustomization, TestCustomization testCustomization2) {
            this();
        }
    }
}

