/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.testutils.utils.reflection;

import java.lang.reflect.Field;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getFieldValue(Object instance, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        assert (instance != null && fieldName != null);
        Field field = ReflectionUtils.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static void setFieldValue(Object instance, String fieldName, Object fieldValue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        assert (instance != null && fieldValue != null && fieldName != null);
        Field field = ReflectionUtils.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        field.set(instance, fieldValue);
    }

    private static Field getField(Class<?> instanceClass, String fieldName) throws NoSuchFieldException {
        assert (fieldName != null);
        try {
            return instanceClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = instanceClass.getSuperclass();
            if (superClass != null) {
                return ReflectionUtils.getField(superClass, fieldName);
            }
            throw e;
        }
    }
}

