/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ControlElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTImageHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ButtonElement
extends ControlElement {
    private boolean isSelected = false;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!e.widget.isDisposed()) {
                ButtonElement.this.isSelected = ButtonElement.this.getButton().getSelection();
                ButtonElement.this.doApplyStyles();
            }
        }
    };

    public ButtonElement(Button button, CSSEngine engine) {
        super((Control)button, engine);
        this.isSelected = button.getSelection();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.dynamicEnabled) {
            return;
        }
        Button button = this.getButton();
        button.addSelectionListener(this.selectionListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.dynamicEnabled) {
            return;
        }
        Button button = this.getButton();
        if (!button.isDisposed()) {
            button.removeSelectionListener(this.selectionListener);
        }
    }

    @Override
    public boolean isPseudoInstanceOf(String s) {
        if ("checked".equals(s)) {
            return this.isSelected;
        }
        return super.isPseudoInstanceOf(s);
    }

    protected Button getButton() {
        return (Button)this.getNativeWidget();
    }

    @Override
    public void reset() {
        super.reset();
        CSSSWTImageHelper.restoreDefaultImage(this.getButton());
    }
}

