/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.orion.editor.swt;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.tools.orion.editor.builder.IHTMLBuilder;
import org.eclipse.e4.tools.orion.editor.swt.BrowserFactory;
import org.eclipse.e4.tools.orion.editor.swt.IDirtyListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class OrionEditorControl
extends Composite {
    private final Browser browser;
    private boolean loaded;
    private ListenerList dirtyListeners;
    private String textToBeSet;
    private Boolean focusToBeSet;
    private Boolean dirtyToBeSet;

    public OrionEditorControl(Composite parent, int style, IHTMLBuilder builder) {
        super(parent, style);
        super.setLayout((Layout)new FillLayout());
        this.browser = BrowserFactory.create(this, this.getBrowserStyle());
        this.browser.setText(builder.getHTML());
        this.createBrowserFunctions();
    }

    protected void createBrowserFunctions() {
        new BrowserFunction(this.browser, "orion_onLoad"){

            public Object function(Object[] arguments) {
                OrionEditorControl.this.onLoad();
                return null;
            }
        };
        new BrowserFunction(this.browser, "orion_dirty"){

            public Object function(Object[] arguments) {
                OrionEditorControl.this.notifyDirtyListeners();
                return null;
            }
        };
    }

    protected Integer getBrowserStyle() {
        return null;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Cannot change internal layout of Editor");
    }

    protected void onLoad() {
        this.loaded = true;
        if (this.textToBeSet != null) {
            this.setText(this.textToBeSet);
            this.textToBeSet = null;
        }
        if (this.focusToBeSet != null) {
            if (this.focusToBeSet.booleanValue()) {
                this.browser.evaluate("editor.focus();");
            }
            this.focusToBeSet = null;
        }
        this.browser.evaluate("window.editor.addEventListener('DirtyChanged', function() {orion_dirty();}, true)");
        if (this.dirtyToBeSet != null) {
            this.setDirty(this.dirtyToBeSet);
            this.dirtyToBeSet = null;
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setText(String text) {
        if (text == null || text.length() == 0) {
            text = "";
        }
        if (this.isLoaded()) {
            this.doSetText(text);
        } else {
            this.textToBeSet = text;
        }
    }

    protected void doSetText(String text) {
        String js = "window.editor.setInput(null, null, \"" + StringEscapeUtils.escapeJavaScript((String)text) + "\", false );";
        this.browser.evaluate(js);
    }

    public String getText() {
        if (!this.isLoaded()) {
            if (this.textToBeSet != null) {
                return this.textToBeSet;
            }
            return "";
        }
        return this.doGetText();
    }

    private String doGetText() {
        return (String)this.browser.evaluate("return editor.getText();");
    }

    public boolean setFocus() {
        boolean result = this.browser.setFocus();
        if (result) {
            if (this.isLoaded()) {
                this.browser.evaluate("window.editor.focus();");
            } else {
                this.focusToBeSet = true;
            }
        }
        return result;
    }

    public void addDirtyListener(IDirtyListener dirtyListener) {
        if (dirtyListener == null) {
            throw new NullPointerException("Cannot add a null dirty listener");
        }
        if (this.dirtyListeners == null) {
            this.dirtyListeners = new ListenerList(1);
        }
        this.dirtyListeners.add((Object)dirtyListener);
    }

    public void removeDirtyListener(IDirtyListener dirtyListener) {
        if (dirtyListener == null) {
            throw new NullPointerException("Cannot remove a null dirty listener");
        }
        if (this.dirtyListeners != null) {
            this.dirtyListeners.remove((Object)dirtyListener);
            if (this.dirtyListeners.isEmpty()) {
                this.dirtyListeners = null;
            }
        }
    }

    private void notifyDirtyListeners() {
        if (this.dirtyListeners == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean dirty = OrionEditorControl.this.isDirty();
                Object[] listeners = OrionEditorControl.this.dirtyListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IDirtyListener dirtyListener = (IDirtyListener)listeners[i];
                    dirtyListener.dirtyChanged(dirty);
                    ++i;
                }
            }
        });
    }

    public void setDirty(boolean dirty) {
        if (this.isLoaded()) {
            this.doSetDirty(dirty);
        } else {
            this.dirtyToBeSet = dirty;
        }
    }

    public void doSetDirty(boolean dirty) {
        String js = "window.editor.setDirty(" + dirty + ");";
        this.browser.evaluate(js);
    }

    public boolean isDirty() {
        if (!this.isLoaded()) {
            if (this.dirtyToBeSet != null) {
                return this.dirtyToBeSet;
            }
            return false;
        }
        Object rc = this.browser.evaluate("return window.editor.isDirty();");
        if (rc instanceof Boolean) {
            return (Boolean)rc;
        }
        return false;
    }
}

