/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiObjectSupplier
extends ExtendedObjectSupplier {
    private final Map<IRequestor, BundleListener> requestor2listener = new HashMap<IRequestor, BundleListener>();
    private final BundleContext localBundleContext = FrameworkUtil.getBundle(OSGiObjectSupplier.class).getBundleContext();

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        Class requestingObjectClass = requestor.getRequestingObjectClass();
        Type desiredType = descriptor.getDesiredType();
        if (BundleContext.class.equals((Object)desiredType)) {
            BundleContext bundleContext;
            Bundle bundle = FrameworkUtil.getBundle((Class)requestingObjectClass);
            if (track) {
                if (!this.requestor2listener.containsKey(requestor)) {
                    this.track(bundle, requestor);
                }
            } else {
                this.untrack(requestor);
            }
            if ((bundleContext = bundle.getBundleContext()) != null) {
                return bundleContext;
            }
            if (descriptor.getQualifier(Optional.class) != null) {
                return null;
            }
            throw new InjectionException("Unable to inject BundleContext: " + bundle.getSymbolicName() + " bundle is not active or starting/stopping");
        }
        if (Bundle.class.equals((Object)desiredType)) {
            return FrameworkUtil.getBundle((Class)requestingObjectClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrack(IRequestor requestor) {
        Map<IRequestor, BundleListener> map = this.requestor2listener;
        synchronized (map) {
            BundleListener l = this.requestor2listener.remove(requestor);
            this.localBundleContext.removeBundleListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void track(final Bundle bundle, final IRequestor requestor) {
        SynchronousBundleListener listener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(bundle) && requestor.isValid()) {
                    requestor.resolveArguments(false);
                    requestor.execute();
                }
            }
        };
        Map<IRequestor, BundleListener> map = this.requestor2listener;
        synchronized (map) {
            this.localBundleContext.addBundleListener((BundleListener)listener);
            this.requestor2listener.put(requestor, (BundleListener)listener);
        }
    }
}

