/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.demo.cheatsheets.search.internal.persistency;

import java.text.MessageFormat;
import org.eclipse.demo.cheatsheets.search.destinations.CSDestination;
import org.eclipse.demo.cheatsheets.search.destinations.LocalCSDestinationsProvider;
import org.eclipse.demo.cheatsheets.search.internal.persistency.CSPersistency;
import org.eclipse.demo.cheatsheets.search.internal.runtime.CheatSheetImpl;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.api.persistence.IMementoLoadProvider;
import org.eclipse.platform.discovery.runtime.api.persistence.MementoLoadProviderException;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;

public class CSLoadProvider
implements IMementoLoadProvider,
CSPersistency {
    public String getDescriptor() {
        return "Cheat Sheet Load Provider";
    }

    public String getChildType() {
        return "cheat-sheet-type";
    }

    public boolean canLoad(IMemento container) {
        return container != null && "cheat-sheet-type".equals(container.getType()) && "cheat-sheet".equals(container.getID());
    }

    public DestinationItemPair load(IMemento container, ILongOperationRunner opRunner) throws MementoLoadProviderException {
        String csID = container.getString("cheat-sheet-id");
        String destinationId = container.getString("cheat-sheet-destination");
        CheatSheetElement sheet = CheatSheetRegistryReader.getInstance().findCheatSheet(csID);
        if (sheet == null) {
            throw new MementoLoadProviderException(MessageFormat.format("Cheat sheet with id={0} not found", csID));
        }
        for (ISearchDestination dest : new LocalCSDestinationsProvider().getSearchDestinations()) {
            if (!((CSDestination)dest).getDestinationID().equals(destinationId)) continue;
            return new DestinationItemPair(dest, (Object)new CheatSheetImpl(sheet, null));
        }
        throw new MementoLoadProviderException(MessageFormat.format("Destination with id={0} not found", destinationId));
    }
}

