/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.databinding.IdentityWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySet<E>
implements Set<E> {
    private IdentityWrapper<E> NULL_WRAPPER;
    private final Set<IdentityWrapper<E>> wrappedSet = new HashSet<IdentityWrapper<E>>();

    public IdentitySet() {
    }

    public IdentitySet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public boolean add(E o) {
        return this.wrappedSet.add(this.wrap(o));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        Iterator<E> iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.wrappedSet.add(this.wrap(iterator.next()));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrappedSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(this.wrapAny(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.wrappedSet.contains(this.wrapAny(iterator.next()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<IdentityWrapper<E>> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                return ((IdentityWrapper)wrappedIterator.next()).unwrap();
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedSet.remove(this.wrapAny(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.remove(iterator.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Object[] retainAll = c.toArray();
        Iterator<E> iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            E element = iterator.next();
            int i = 0;
            while (i < retainAll.length) {
                if (element == retainAll[i]) continue block0;
                ++i;
            }
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.wrappedSet.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.wrappedSet.size();
        IdentityWrapper[] wrappedArray = this.wrappedSet.toArray(new IdentityWrapper[size]);
        Object[] result = a;
        if (a.length < size) {
            result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while (i < size) {
            result[i] = wrappedArray[i].unwrap();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        return this.size() == that.size() && this.containsAll(that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (E element : this) {
            hash += element == null ? 0 : element.hashCode();
        }
        return hash;
    }

    private IdentityWrapper<E> getNullWrapper() {
        if (this.NULL_WRAPPER == null) {
            this.NULL_WRAPPER = new IdentityWrapper<Object>(null);
        }
        return this.NULL_WRAPPER;
    }

    private IdentityWrapper<E> wrap(E obj) {
        return obj == null ? this.getNullWrapper() : new IdentityWrapper<E>(obj);
    }

    private IdentityWrapper<?> wrapAny(Object obj) {
        return obj == null ? this.getNullWrapper() : new IdentityWrapper<Object>(obj);
    }
}

