/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StalenessObservableValue
extends AbstractObservableValue<Boolean> {
    private IObservable tracked;
    private boolean stale;
    private MyChangeListener changeListener = new MyChangeListener();
    private MyStaleListener staleListener = new MyStaleListener();

    public StalenessObservableValue(IObservable observable) {
        super(observable.getRealm());
        this.tracked = observable;
        this.stale = observable.isStale();
        this.tracked.addChangeListener(this.changeListener);
        this.tracked.addStaleListener(this.staleListener);
    }

    @Override
    protected Boolean doGetValue() {
        return this.tracked.isStale() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object getValueType() {
        return Boolean.TYPE;
    }

    @Override
    public synchronized void dispose() {
        if (this.tracked != null) {
            this.tracked.removeChangeListener(this.changeListener);
            this.tracked.removeStaleListener(this.staleListener);
            this.tracked = null;
            this.changeListener = null;
            this.staleListener = null;
        }
        super.dispose();
    }

    private class MyChangeListener
    implements IChangeListener {
        private MyChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            if (StalenessObservableValue.this.stale && !event.getObservable().isStale()) {
                StalenessObservableValue.this.stale = false;
                StalenessObservableValue.this.fireValueChange(Diffs.createValueDiff(Boolean.TRUE, Boolean.FALSE));
            }
        }
    }

    private class MyStaleListener
    implements IStaleListener {
        private MyStaleListener() {
        }

        public void handleStale(StaleEvent staleEvent) {
            if (!StalenessObservableValue.this.stale) {
                StalenessObservableValue.this.stale = true;
                StalenessObservableValue.this.fireValueChange(Diffs.createValueDiff(Boolean.FALSE, Boolean.TRUE));
            }
        }
    }
}

