/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.value.ChangeVetoException;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangingListener;
import org.eclipse.core.databinding.observable.value.IVetoableValue;
import org.eclipse.core.databinding.observable.value.ValueChangingEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingVetoableValue<T>
extends DecoratingObservableValue<T>
implements IVetoableValue<T> {
    protected ListenerList<IValueChangingListener<T>> valueChangingListListener = null;

    public DecoratingVetoableValue(IObservableValue<T> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
    }

    @Override
    public void setValue(T value) {
        this.checkRealm();
        Object currentValue = this.getValue();
        ValueDiff diff = Diffs.createValueDiff(currentValue, value);
        boolean okToProceed = this.fireValueChanging(diff);
        if (!okToProceed) {
            throw new ChangeVetoException("Change not permitted");
        }
        super.setValue(value);
    }

    @Override
    public synchronized void addValueChangingListener(IValueChangingListener<T> listener) {
        if (this.valueChangingListListener == null) {
            this.valueChangingListListener = new ListenerList();
        }
        this.addListener(this.valueChangingListListener, listener);
    }

    @Override
    public synchronized void removeValueChangingListener(IValueChangingListener<T> listener) {
        if (this.valueChangingListListener != null) {
            this.removeListener(this.valueChangingListListener, listener);
        }
    }

    @Override
    protected boolean hasListeners() {
        return this.valueChangingListListener != null && this.valueChangingListListener.hasListeners() || super.hasListeners();
    }

    protected boolean fireValueChanging(ValueDiff<T> diff) {
        this.checkRealm();
        ValueChangingEvent<T> event = new ValueChangingEvent<T>(this, diff);
        if (this.valueChangingListListener != null) {
            this.valueChangingListListener.fireEvent(event);
        }
        return !event.veto;
    }
}

