/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.util;

import org.eclipse.platform.discovery.ui.internal.SlidingComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class DiscoveryUiUtil {
    private static DiscoveryUiUtil instance;

    private DiscoveryUiUtil() {
    }

    public static DiscoveryUiUtil instance() {
        if (instance == null) {
            instance = new DiscoveryUiUtil();
        }
        return instance;
    }

    public int getHeightOrWidthDependingOnOrientation(Control control, SlidingComposite.ORIENTATION orientation) {
        int size = this.pointComponent(control.getSize(), orientation);
        if (size == 0) {
            size = this.pointComponent(control.computeSize(-1, -1), orientation);
        }
        return size;
    }

    public int pointComponent(Point point, SlidingComposite.ORIENTATION orientation) {
        switch (orientation) {
            case VERTICAL: {
                return point.y;
            }
            case HORIZONTAL: {
                return point.x;
            }
        }
        throw new IllegalArgumentException("Unsupported alignment");
    }
}

