/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.tooltip;

import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.platform.discovery.ui.internal.tooltip.IToolTipConfigurator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TooltipInformation
extends AbstractInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private final FormToolkit toolkit = this.createFormToolkit();
    private Form tooltipForm;

    public TooltipInformation(Shell parent) {
        super(parent, false);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TooltipInformation.this.dispose();
            }
        });
        this.create();
    }

    public void setInput(Object input) {
        this.disposeChildren(this.tooltipForm.getBody());
        if (input == null) {
            return;
        }
        assert (input instanceof IToolTipConfigurator);
        IToolTipConfigurator configurator = (IToolTipConfigurator)input;
        this.tooltipForm.setImage(configurator.getTitleImage());
        this.tooltipForm.setText(configurator.getTitleCaption());
        FormText text = this.createMessageTextField(this.tooltipForm.getBody(), configurator);
        text.setText(configurator.getFormText(), true, true);
        this.tooltipForm.layout(true);
        this.tooltipForm.pack();
        this.getShell().pack();
    }

    public Point computeSizeHint() {
        return this.getShell().computeSize(-1, -1, true);
    }

    private void disposeChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    protected void createContent(Composite parent) {
        this.tooltipForm = this.createForm(parent);
    }

    protected FormText createMessageTextField(Composite parent, IToolTipConfigurator configurator) {
        FormText text = this.toolkit.createFormText(parent, true);
        GridData td = new GridData();
        text.setLayoutData((Object)td);
        text.setBackground(this.tooltipBackgroundColor(parent.getDisplay()));
        return text;
    }

    protected Form createForm(Composite parent) {
        Form form = this.getFormToolkit().createForm(parent);
        form.setBackground(this.tooltipBackgroundColor(parent.getDisplay()));
        GridLayout layout = new GridLayout(1, true);
        form.getBody().setLayout((Layout)layout);
        return form;
    }

    protected FormToolkit createFormToolkit() {
        return new FormToolkit(PlatformUI.getWorkbench().getDisplay());
    }

    protected FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    private Color tooltipBackgroundColor(Display display) {
        return display.getSystemColor(29);
    }

    public boolean hasContents() {
        return this.tooltipForm.getBody().getChildren().length > 0;
    }

    public void dispose() {
        if (this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

