/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.platform.discovery.ui.api.impl.ErrorHandler;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ErrorHandlerPageObject {
    private final SwtBotUtils botUtils;
    private final SWTBot bot;
    private final IErrorHandler errorHandler;
    private final LoggerPageObject logger;
    private SWTBotShell errorShell;

    public ErrorHandlerPageObject() {
        final ILogger loggerMock = (ILogger)Mockito.mock(ILogger.class);
        this.logger = new LoggerPageObject(loggerMock);
        this.errorHandler = new ErrorHandler(){

            protected ILogger logger() {
                return loggerMock;
            }
        };
        this.bot = new SWTBot();
        this.botUtils = new SwtBotUtils();
    }

    public boolean isOpen() {
        return this.errorShell != null;
    }

    public void close() {
        this.errorShell.bot().button(IDialogConstants.OK_LABEL).click();
        this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)this.errorShell));
        this.errorShell = null;
    }

    public void showError(String title, String details) {
        this.errorHandler.showError(title, details);
        this.errorShell = this.bot.shell(title);
    }

    public String getTitleShown() {
        return this.errorShell.getText();
    }

    public String getDetailsShown() {
        SWTBotText text = this.detailsText();
        return text.getText();
    }

    private SWTBotText detailsText() {
        return this.errorShell.bot().text();
    }

    public boolean isDetailsReadOnly() {
        return this.botUtils.isReadOnly((AbstractSWTBot<? extends Widget>)this.detailsText());
    }

    public LoggerPageObject getLogger() {
        return this.logger;
    }

    public void handleException(Exception exception, String errorDialogTitle) {
        this.errorHandler.handleException(errorDialogTitle, exception);
        this.errorShell = this.bot.shell(errorDialogTitle);
    }

    public static class LoggerPageObject {
        private final ILogger loggerMock;

        private LoggerPageObject(ILogger mock) {
            this.loggerMock = mock;
        }

        public void checkExceptionWasLogged(Exception ex) {
            ((ILogger)Mockito.verify((Object)this.loggerMock, (VerificationMode)Mockito.times((int)1))).logError(Matchers.anyString(), (Throwable)Matchers.same((Object)ex));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.loggerMock});
        }
    }
}

