/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.platform.discovery.runtime.api.IConflict;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.SubdestinationsActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchSubdestinationExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.model.ConflictBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.DestinationCategoryDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.ObjectTypeDescriptionBuilder;
import org.eclipse.platform.discovery.testutils.utils.model.SubdestinationBuilder;
import org.mockito.Mockito;

public class SubdestinationsActivationConfigTest
extends TestCase {
    private final String OBJECT_TYPE_ID = "myobject";
    private final String DEST_CATEGORY_ID = "mydestination";
    private final String SUBDEST_ID = "mysubdestination";
    private final String OTHER_OBJECT_TYPE_ID = "other_myobject";
    private final String OTHER_DEST_CATEGORY_ID = "other_mydestination";
    private final String OTHER_SUBDEST_ID = "other_mysubdestination";
    private final String WITH_CONF_SUBDEST_ID = "withconflicts_mysubdestination";
    private ISearchSubdestinationExtensionParser parser;
    private IObjectTypeDescription objectType;
    private IDestinationCategoryDescription destinationCategory;
    private ISearchProviderDescription searchProvider;
    private ISearchSubdestination subdestination;
    private ISearchSubdestination otherSubdestination;
    private ISearchSubdestination subdestinationWithConflicts;
    private SubdestinationsActivationConfig config;

    protected void setUp() throws Exception {
        this.objectType = (IObjectTypeDescription)new ObjectTypeDescriptionBuilder().withId("myobject").object();
        this.destinationCategory = (IDestinationCategoryDescription)new DestinationCategoryDescriptionBuilder().withId("mydestination").object();
        this.subdestination = (ISearchSubdestination)new SubdestinationBuilder().withDestCategoryId("mydestination").forObjectType("myobject").withId("mysubdestination").object();
        this.otherSubdestination = (ISearchSubdestination)new SubdestinationBuilder().withDestCategoryId("other_mydestination").forObjectType("other_myobject").withId("other_mysubdestination").object();
        this.subdestinationWithConflicts = (ISearchSubdestination)new SubdestinationBuilder().withDestCategoryId("mydestination").forObjectType("myobject").conflictsTo(new IConflict[]{(IConflict)new ConflictBuilder().conflictsToSubdestination("mysubdestination").object()}).withId("withconflicts_mysubdestination").object();
        this.searchProvider = (ISearchProviderDescription)Mockito.mock(ISearchProviderDescription.class);
        this.parser = (ISearchSubdestinationExtensionParser)Mockito.mock(ISearchSubdestinationExtensionParser.class);
        Mockito.when((Object)this.parser.readContributions()).thenReturn(Arrays.asList(this.subdestination, this.otherSubdestination, this.subdestinationWithConflicts));
        this.config = new SubdestinationsActivationConfig(this.parser);
    }

    public void testGetAvailableSubdestinations() {
        List result = this.config.getAvailableSearchSubdestinations(this.objectType, this.destinationCategory, this.searchProvider);
        SubdestinationsActivationConfigTest.assertEquals((String)"Two subdestinations expected", (int)2, (int)result.size());
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination not found", (boolean)result.contains(this.subdestination));
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination not found", (boolean)result.contains(this.subdestinationWithConflicts));
    }

    public void testSubdestActivationNotDefaultSelected() {
        this.setDefaultSelected(this.subdestination, false);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled by default", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled by default", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination should be enabled", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, false);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
    }

    private void setDefaultSelected(ISearchSubdestination subdestination, boolean value) {
        Mockito.when((Object)subdestination.isDefaultSelected()).thenReturn((Object)value);
    }

    public void testSubdestActivationDefaultSelected() {
        this.setDefaultSelected(this.subdestination, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination should be enabled by default", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination should be enabled by default", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, false);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination should be enabled", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
    }

    public void testSubdestNotContributed() {
        this.setDefaultSelected(this.subdestination, true);
        this.setDefaultSelected(this.otherSubdestination, false);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled by default", (boolean)this.config.isSubdestinationActive(this.otherSubdestination, this.objectType, this.destinationCategory, this.searchProvider));
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled by default", (boolean)this.config.isSubdestinationActive(this.otherSubdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.otherSubdestination, true);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled as it is not recognized", (boolean)this.config.isSubdestinationActive(this.otherSubdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.otherSubdestination, false);
        SubdestinationsActivationConfigTest.assertFalse((String)"Subdestination should be disabled", (boolean)this.config.isSubdestinationActive(this.otherSubdestination, this.objectType, this.destinationCategory, this.searchProvider));
    }

    public void testConflictingSubdestinations() {
        this._testConflictingSubdestinations(true);
    }

    public void testConflictingSubdestinationsSymmetry() {
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestinationWithConflicts, true);
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, true);
        SubdestinationsActivationConfigTest.assertFalse((String)"Conflicting subdestinations reflexion test failed", (boolean)this.config.isSubdestinationActive(this.subdestinationWithConflicts, this.objectType, this.destinationCategory, this.searchProvider));
    }

    public void testConflictingSubdestinationsDefaultSelected() {
        this.setDefaultSelected(this.subdestination, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subdestination should be enabled by default", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestinationWithConflicts, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subd should be active after activateSubdestination() is called, but it isn't", (boolean)this.config.isSubdestinationActive(this.subdestinationWithConflicts, this.objectType, this.destinationCategory, this.searchProvider));
        SubdestinationsActivationConfigTest.assertFalse((String)"Conflicting subdestinations should be deactivated on activating a subdestination which has conflicts", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
    }

    public void testConflictingSubdestinationsWithCache() {
        this._testConflictingSubdestinations(true);
        this._testConflictingSubdestinations(false);
    }

    private void _testConflictingSubdestinations(boolean firstTime) {
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestination, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subd should be active after activateSubdestination() is called, but it isn't", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
        this.config.activateSubdestination(this.objectType, this.destinationCategory, this.searchProvider, this.subdestinationWithConflicts, true);
        SubdestinationsActivationConfigTest.assertTrue((String)"Subd should be active after activateSubdestination() is called, but it isn't", (boolean)this.config.isSubdestinationActive(this.subdestinationWithConflicts, this.objectType, this.destinationCategory, this.searchProvider));
        SubdestinationsActivationConfigTest.assertFalse((String)"Conflicting subdestinations should be deactivated on activating a subdestination which has conflicts", (boolean)this.config.isSubdestinationActive(this.subdestination, this.objectType, this.destinationCategory, this.searchProvider));
    }
}

