/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.DestinationsProviderExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;
import org.mockito.Mockito;

public class DestinationsProviderExtensionParserTest
extends AbstractExtensionPointParserTest<IDestinationsProviderDescription> {
    private static final String PROVIDER_ID = "mydestprovider";
    private static final String PROVIDER_CAT = "mycategory";
    private static final String PROVIDER_FQNAME = "org.eclipse.test.MyTestProvider";
    private static final String PROVIDER_PREF_PAGE = "org.eclipse.test.MyPrefPage";
    protected IDestinationsProvider providerInstance;

    protected AbstractExtensionPointParser<IDestinationsProviderDescription> createParser(IExtensionRegistry registry) {
        return new DestinationsProviderExtensionParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        this.providerInstance = (IDestinationsProvider)Mockito.mock(IDestinationsProvider.class, (String)"destination provider instance");
        registryBuilder.addDestinationsProvider(PROVIDER_ID, PROVIDER_CAT, PROVIDER_PREF_PAGE, PROVIDER_FQNAME, this.providerInstance);
    }

    protected void verifyContributions(List<IDestinationsProviderDescription> contributions) {
        Assert.assertEquals((String)"one destination provider expected", (long)1L, (long)contributions.size());
        IDestinationsProviderDescription providerDesc = contributions.get(0);
        Assert.assertEquals((String)"Unexpected id", (Object)PROVIDER_ID, (Object)providerDesc.getId());
        Assert.assertEquals((String)"Unexpected category", (Object)PROVIDER_CAT, (Object)providerDesc.getDestinationCategoryId());
        Assert.assertEquals((String)"Unexpected display name", (Object)PROVIDER_FQNAME, (Object)providerDesc.getDisplayName());
        Assert.assertEquals((String)"Unexpected preference page id", (Object)PROVIDER_PREF_PAGE, (Object)providerDesc.getPreferencePageId());
        Assert.assertSame((String)"uenxpected provider returned", (Object)this.providerInstance, (Object)providerDesc.createProvider());
    }
}

