/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;

public class ComponentLabelProvider
extends StyledCellLabelProvider {
    private ModelEditor editor;
    public static final String NOT_RENDERED_KEY = "NOT_RENDERED_STYLER";
    public static final String NOT_VISIBLE_KEY = "NOT_VISIBLE_KEY";
    public static final String NOT_VISIBLE_AND_RENDERED_KEY = "NOT_VISIBLE_AND_RENDERED_KEY";
    private Font font;
    private Messages Messages;
    private static StyledString.Styler BOTH_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_VISIBLE_AND_RENDERED_KEY);
            textStyle.strikeout = true;
        }
    };
    private static StyledString.Styler NOT_RENDERED_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_RENDERED_KEY);
            textStyle.strikeout = true;
        }
    };
    private static StyledString.Styler NOT_VISIBLE_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get(ComponentLabelProvider.NOT_VISIBLE_KEY);
        }
    };

    public ComponentLabelProvider(ModelEditor editor, Messages Messages2) {
        this.editor = editor;
        this.Messages = Messages2;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof EObject) {
            EObject o = (EObject)cell.getElement();
            AbstractComponentEditor elementEditor = this.editor.getEditor(o.eClass());
            if (elementEditor != null) {
                String label = elementEditor.getLabel(o);
                String detailText = elementEditor.getDetailLabel(o);
                StyledString.Styler styler = null;
                if (o instanceof MUIElement) {
                    if (!((MUIElement)o).isVisible() && !((MUIElement)o).isToBeRendered()) {
                        label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_invisible + "/" + this.Messages.ComponentLabelProvider_notrendered + ">";
                        styler = BOTH_STYLER;
                    } else if (!((MUIElement)o).isVisible()) {
                        label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_invisible + ">";
                        styler = NOT_VISIBLE_STYLER;
                    } else if (!((MUIElement)o).isToBeRendered()) {
                        label = String.valueOf(label) + "<" + this.Messages.ComponentLabelProvider_notrendered + ">";
                        styler = NOT_RENDERED_STYLER;
                    }
                }
                if (detailText == null) {
                    StyledString styledString = new StyledString(label, styler);
                    cell.setText(styledString.getString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                } else {
                    StyledString styledString = new StyledString(label, styler);
                    styledString.append(" - " + detailText, StyledString.DECORATIONS_STYLER);
                    cell.setText(styledString.getString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                }
                cell.setImage(elementEditor.getImage(o, cell.getControl().getDisplay()));
            } else {
                cell.setText(cell.getElement().toString());
            }
        } else if (cell.getElement() instanceof VirtualEntry) {
            String s = cell.getElement().toString();
            if (this.font == null) {
                FontData[] data = cell.getControl().getFont().getFontData();
                this.font = new Font((Device)cell.getControl().getDisplay(), new FontData(data[0].getName(), data[0].getHeight(), 2));
            }
            cell.setFont(this.font);
            cell.setText(s);
        } else {
            cell.setText(cell.getElement().toString());
        }
    }

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
        super.dispose();
    }
}

