/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.languages.javascript.JSExportPackage;
import org.eclipse.e4.internal.languages.javascript.JSVersionRange;

public class JSImportPackage {
    private String name;
    private JSVersionRange versionRange = JSVersionRange.emptyRange;
    private String bundleSymbolicName;
    private JSVersionRange bundleVersionRange = JSVersionRange.emptyRange;
    private boolean optional = false;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private JSExportPackage wiredExport;

    public JSImportPackage(String header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.parseImport(header);
    }

    private void parseImport(String header) {
        StringTokenizer tokenizer = new StringTokenizer(header, ";");
        this.name = tokenizer.nextToken().trim();
        while (tokenizer.hasMoreTokens()) {
            String token = (String)tokenizer.nextElement();
            if (token.indexOf(":=") != -1) {
                this.parseDirective(token);
                continue;
            }
            if (token.indexOf("=") != -1) {
                this.parseAttribute(token);
                continue;
            }
            throw new IllegalArgumentException("bad import syntax: " + token + " in " + header);
        }
    }

    private void parseAttribute(String token) {
        int index = token.indexOf("=");
        String attributeName = token.substring(0, index).trim();
        if (attributeName.length() == 0) {
            return;
        }
        String value = token.substring(index + "=".length()).trim();
        if (attributeName.equals("version")) {
            this.versionRange = new JSVersionRange(value);
        } else if (attributeName.equals("bundle-symbolic-name")) {
            this.bundleSymbolicName = value;
        } else if (attributeName.equals("bundle-version")) {
            this.bundleVersionRange = new JSVersionRange(value);
        }
        this.attributes.put(attributeName, value);
    }

    private void parseDirective(String token) {
        int index = token.indexOf(":=");
        String directiveName = token.substring(0, index).trim();
        if (directiveName.length() == 0) {
            return;
        }
        String value = token.substring(index + ":=".length()).trim();
        if (directiveName.equals("resolution")) {
            this.optional = "optional".equals(value);
        }
        this.directives.put(directiveName, value);
    }

    public String getName() {
        return this.name;
    }

    public JSVersionRange getVersionRange() {
        return this.versionRange;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public JSVersionRange getBundleVersionRange() {
        return this.bundleVersionRange;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public boolean wire(JSExportPackage candidate) {
        Object value;
        if (!this.name.equals(candidate.getName())) {
            return false;
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (key.equals("version")) {
                if (this.versionRange.isIncluded(candidate.getVersion())) continue;
                return false;
            }
            if (key.equals("bundle-symbolic-name")) {
                if (this.bundleSymbolicName.equals(candidate.getBundleSymbolicName())) continue;
                return false;
            }
            if (key.equals("bundle-version")) {
                if (this.bundleVersionRange.isIncluded(candidate.getBundleVersion())) continue;
                return false;
            }
            value = entry.getValue();
            Object attributeValue = candidate.getAttributes().get(key);
            if (attributeValue != null && attributeValue.equals(value)) continue;
            return false;
        }
        iterator = candidate.getMandatory().iterator();
        while (iterator.hasNext()) {
            String key = (String)((Object)iterator.next());
            Object mandatoryValue = candidate.getAttributes().get(key);
            value = this.attributes.get(key);
            if (value != null && value.equals(mandatoryValue)) continue;
            return false;
        }
        this.wiredExport = candidate;
        return true;
    }

    public JSExportPackage getWiredExport() {
        return this.wiredExport;
    }

    public void unwire() {
        this.wiredExport = null;
    }
}

