/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import org.eclipse.core.databinding.conversion.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterToStringConverter
extends Converter<Object, Object> {
    private final boolean primitive;

    private CharacterToStringConverter(boolean primitive) {
        super(primitive ? Character.TYPE : Character.class, String.class);
        this.primitive = primitive;
    }

    @Override
    public Object convert(Object fromObject) {
        if (fromObject == null) {
            if (this.primitive) {
                throw new IllegalArgumentException("'fromObject' is null. Cannot convert to primitive char.");
            }
            return "";
        }
        if (!(fromObject instanceof Character)) {
            throw new IllegalArgumentException("'fromObject' is not of type [Character].");
        }
        return String.valueOf(((Character)fromObject).charValue());
    }

    public static CharacterToStringConverter fromCharacter(boolean primitive) {
        return new CharacterToStringConverter(primitive);
    }
}

