/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.value;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.core.internal.databinding.property.value.ListDelegatingValueObservableList;
import org.eclipse.core.internal.databinding.property.value.MapDelegatingValueObservableMap;
import org.eclipse.core.internal.databinding.property.value.SetDelegatingValueObservableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingValueProperty<S, T>
extends ValueProperty<S, T> {
    private final Object valueType;
    private final IValueProperty<S, T> nullProperty = new NullValueProperty();

    protected DelegatingValueProperty() {
        this(null);
    }

    protected DelegatingValueProperty(Object valueType) {
        this.valueType = valueType;
    }

    public final IValueProperty<S, T> getDelegate(S source) {
        if (source == null) {
            return this.nullProperty;
        }
        IValueProperty<S, T> delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract IValueProperty<S, T> doGetDelegate(S var1);

    @Override
    protected T doGetValue(S source) {
        return this.getDelegate(source).getValue(source);
    }

    @Override
    protected void doSetValue(S source, T value) {
        this.getDelegate(source).setValue(source, value);
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public IObservableValue<T> observe(S source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableValue<T> observe(Realm realm, S source) {
        return this.getDelegate(source).observe(realm, source);
    }

    @Override
    public <U extends S> IObservableList<T> observeDetail(IObservableList<U> master) {
        return new ListDelegatingValueObservableList(master, this);
    }

    @Override
    public <U extends S> IObservableMap<U, T> observeDetail(IObservableSet<U> master) {
        return new SetDelegatingValueObservableMap(master, this);
    }

    @Override
    public <K, V extends S> IObservableMap<K, T> observeDetail(IObservableMap<K, V> master) {
        return new MapDelegatingValueObservableMap(master, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NullValueProperty
    extends SimpleValueProperty<S, T> {
        private NullValueProperty() {
        }

        @Override
        public Object getValueType() {
            return DelegatingValueProperty.this.valueType;
        }

        @Override
        protected T doGetValue(S source) {
            return null;
        }

        @Override
        protected void doSetValue(S source, T value) {
        }

        @Override
        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<ValueDiff<T>> listener) {
            return null;
        }
    }
}

