/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.set.ObservableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListToSetAdapter<E>
extends ObservableSet<E> {
    private final IObservableList<E> list;
    private IListChangeListener<E> listener = new IListChangeListener<E>(){

        @Override
        public void handleListChange(ListChangeEvent<E> event) {
            HashSet added = new HashSet();
            HashSet removed = new HashSet();
            List differences = event.diff.getDifferencesAsList();
            for (ListDiffEntry entry : differences) {
                Object element = entry.getElement();
                if (entry.isAddition()) {
                    if (!ListToSetAdapter.this.wrappedSet.add(element) || removed.remove(element)) continue;
                    added.add(element);
                    continue;
                }
                if (!ListToSetAdapter.this.wrappedSet.remove(element)) continue;
                removed.add(element);
                added.remove(element);
            }
            ListToSetAdapter.this.fireSetChange(Diffs.createSetDiff(added, removed));
        }
    };

    public ListToSetAdapter(IObservableList<E> list) {
        super(list.getRealm(), new HashSet(), list.getElementType());
        this.list = list;
        this.wrappedSet.addAll(list);
        this.list.addListChangeListener(this.listener);
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.list != null && this.listener != null) {
            this.list.removeListChangeListener(this.listener);
            this.listener = null;
        }
    }
}

