/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.actions.SurroundWithTryCatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;

public class SurroundWithTryMultiCatchAction
extends SurroundWithTryCatchAction {
    public SurroundWithTryMultiCatchAction(CompilationUnitEditor editor) {
        super(editor);
        this.setText(RefactoringMessages.SurroundWithTryMultiCatchAction_label);
    }

    public void run(ITextSelection selection) {
        ICompilationUnit compilationUnit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IJavaProject javaProject = compilationUnit.getJavaProject();
        if (!JavaModelUtil.is17OrHigher(javaProject)) {
            String message = Messages.format(RefactoringMessages.SurroundWithTryMultiCatchAction_not17, BasicElementLabels.getJavaElementName(javaProject.getElementName()));
            MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)this.getDialogTitle(), (String)message);
            return;
        }
        super.run(selection);
    }

    SurroundWithTryCatchRefactoring createRefactoring(ITextSelection selection, ICompilationUnit cu) {
        return SurroundWithTryCatchRefactoring.create(cu, selection, true);
    }

    String getDialogTitle() {
        return RefactoringMessages.SurroundWithTryMultiCatchAction_dialog_title;
    }

    boolean isApplicable() {
        if (!super.isApplicable()) {
            return false;
        }
        ICompilationUnit compilationUnit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IJavaProject javaProject = compilationUnit.getJavaProject();
        return JavaModelUtil.is17OrHigher(javaProject);
    }
}

