/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.actions.expressions.EditWatchExpressionAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.expression.ExpressionView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class EditWatchExpressinInPlaceAction
extends Action
implements ISelectionChangedListener {
    private ExpressionView fView;
    private TreeModelViewer fViewer;
    private EditWatchExpressionAction fEditActionDelegate = new EditWatchExpressionAction();

    public EditWatchExpressinInPlaceAction(ExpressionView view) {
        this.fView = view;
        this.fViewer = (TreeModelViewer)view.getViewer();
        this.fEditActionDelegate.init(view);
        ISelectionProvider selectionProvider = this.fView.getSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fEditActionDelegate.selectionChanged((IAction)this, selectionProvider.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = this.fEditActionDelegate.getCurrentSelection();
        this.setEnabled(selection != null && selection.size() == 1);
    }

    public void dispose() {
        this.fView.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        IStructuredSelection selelection = this.fEditActionDelegate.getCurrentSelection();
        if (selelection.size() != 1) {
            return;
        }
        int expressionColumn = this.getExpressionColumnIndex();
        if (expressionColumn != -1 || this.isWatchExpressionWithNewLine()) {
            this.fViewer.editElement(selelection.getFirstElement(), expressionColumn);
        } else {
            this.fEditActionDelegate.run((IAction)this);
        }
    }

    private boolean isWatchExpressionWithNewLine() {
        IWatchExpression[] expressions = this.fEditActionDelegate.getSelectedExpressions();
        return expressions.length == 1 && expressions[0].getExpressionText().indexOf(10) == -1;
    }

    private int getExpressionColumnIndex() {
        Object[] columnProperties = this.fViewer.getColumnProperties();
        int i = 0;
        while (i < columnProperties.length) {
            if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnProperties[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

