/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Computation {
    protected Map<EclipseContext, Set<String>> dependencies = new HashMap<EclipseContext, Set<String>>();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public void addDependency(EclipseContext context, String name) {
        Set<String> properties = this.dependencies.get(context);
        if (properties == null) {
            properties = new HashSet<String>(4);
            this.dependencies.put(context, properties);
        }
        properties.add(name);
    }

    protected void doHandleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
    }

    public void handleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduled) {
        String name = event.getName();
        EclipseContext context = (EclipseContext)event.getContext();
        this.stopListening(context, name);
        this.doHandleInvalid(event, scheduled);
    }

    protected void removeAll() {
        for (EclipseContext c : this.dependencies.keySet()) {
            c.removeListener(this);
        }
        this.dependencies.clear();
    }

    public void startListening() {
        for (EclipseContext c : this.dependencies.keySet()) {
            c.addListener(this, this.dependencies.get(c));
        }
    }

    public void stopListening(EclipseContext context, String name) {
        if (context == null) {
            Set<EclipseContext> dependentContexts = this.dependencies.keySet();
            for (EclipseContext dependentContext : dependentContexts) {
                dependentContext.removeListener(this);
            }
            return;
        }
        if (name == null) {
            this.dependencies.remove(context);
            context.removeListener(this);
            return;
        }
        Set<String> properties = this.dependencies.get(context);
        if (properties != null) {
            properties.remove(name);
            if (properties.isEmpty()) {
                this.dependencies.remove(context);
                context.removeListener(this);
            }
        }
    }

    public Set<String> dependsOnNames(IEclipseContext context) {
        return this.dependencies.get(context);
    }
}

