/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    static ImageTransfer _instance = new ImageTransfer();
    static final String PICT = "PICT";
    static final String TIFF = "TIFF";
    static final int PICTID = ImageTransfer.registerType("PICT");
    static final int TIFFID = ImageTransfer.registerType("TIFF");

    ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -1;
        ImageData imgData = (ImageData)object;
        Image image = new Image((Device)Display.getCurrent(), imgData);
        int handle = image.handle;
        int width = OS.CGImageGetWidth(handle);
        int height = OS.CGImageGetHeight(handle);
        int alphaInfo = OS.CGImageGetAlphaInfo(handle);
        int bpr = OS.CGImageGetBytesPerRow(handle);
        Rect rect = new Rect();
        rect.left = 0;
        rect.top = 0;
        rect.right = (short)width;
        rect.bottom = (short)height;
        int[] gWorld = new int[1];
        int format = 24;
        if (alphaInfo != 6) {
            format = 32;
        }
        OS.NewGWorldFromPtr(gWorld, format, rect, 0, 0, 0, image.data, bpr);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld(curPort, curGWorld);
        OS.SetGWorld(gWorld[0], curGWorld[0]);
        int pictHandle = OS.OpenPicture(rect);
        int portBitMap = OS.GetPortBitMapForCopyBits(gWorld[0]);
        OS.CopyBits(portBitMap, portBitMap, rect, rect, (short)0, 0);
        OS.ClosePicture();
        OS.SetGWorld(curPort[0], curGWorld[0]);
        OS.DisposeGWorld(gWorld[0]);
        int length = OS.GetHandleSize(pictHandle);
        OS.HLock(pictHandle);
        int[] buffer = new int[1];
        OS.memmove(buffer, pictHandle, 4);
        byte[] pictData = new byte[length];
        OS.memmove(pictData, buffer[0], length);
        OS.HUnlock(pictHandle);
        OS.KillPicture(pictHandle);
        image.dispose();
        transferData.data = new byte[][]{pictData};
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        byte[] dataArr = transferData.data[0];
        int size = dataArr.length;
        int pictPtr = OS.NewPtr(size);
        OS.memmove(pictPtr, dataArr, size);
        int dataProvider = OS.CGDataProviderCreateWithData(0, pictPtr, size, 0);
        if (dataProvider != 0) {
            int bpc;
            int context;
            int colorspace;
            int provider;
            int pictDataRef = OS.QDPictCreateWithProvider(dataProvider);
            CGRect rect = new CGRect();
            OS.QDPictGetBounds(pictDataRef, rect);
            int width = (int)rect.width;
            int height = (int)rect.height;
            int bpr = width * 4;
            int dataSize = height * bpr;
            int data = OS.NewPtr(dataSize);
            if (data == 0) {
                SWT.error(2);
            }
            if ((provider = OS.CGDataProviderCreateWithData(0, data, dataSize, 0)) == 0) {
                OS.DisposePtr(data);
                SWT.error(2);
            }
            if ((colorspace = OS.CGColorSpaceCreateDeviceRGB()) == 0) {
                SWT.error(2);
            }
            int handle = OS.CGImageCreate(width, height, 8, 32, bpr, colorspace, 6, provider, null, true, 0);
            OS.CGDataProviderRelease(provider);
            if (handle == 0) {
                OS.DisposePtr(data);
                SWT.error(2);
            }
            if ((context = OS.CGBitmapContextCreate(data, width, height, bpc = OS.CGImageGetBitsPerComponent(handle), bpr, colorspace, 6)) == 0) {
                OS.CGImageRelease(handle);
                OS.DisposePtr(data);
                SWT.error(2);
            }
            int status = OS.QDPictDrawToCGContext(context, rect, pictDataRef);
            ImageData imgData = null;
            if (status == 0) {
                Image image = Image.carbon_new(Display.getCurrent(), 0, handle, data);
                imgData = image.getImageData();
                image.dispose();
            }
            OS.CGContextRelease(context);
            OS.QDPictRelease(pictDataRef);
            return imgData;
        }
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{PICTID};
    }

    protected String[] getTypeNames() {
        return new String[]{PICT};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

