/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML = "HTML";
    static final int HTMLID = HTMLTransfer.registerType("HTML");

    HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        transferData.result = -1;
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        if (cfstring == 0) {
            return;
        }
        byte[] buffer = null;
        try {
            CFRange range = new CFRange();
            range.length = chars.length;
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, false, null, 0, size);
            if (numChars == 0) {
                return;
            }
            buffer = new byte[size[0]];
            numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, false, buffer, size[0], size);
            if (numChars == 0) {
                return;
            }
        }
        finally {
            OS.CFRelease(cfstring);
        }
        transferData.data = new byte[1][];
        transferData.data[0] = buffer;
        transferData.result = 0;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        byte[] buffer = transferData.data[0];
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, false);
        if (cfstring == 0) {
            return null;
        }
        try {
            int length = OS.CFStringGetLength(cfstring);
            if (length == 0) {
                return null;
            }
            char[] chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(cfstring, range, chars);
            String string = new String(chars);
            return string;
        }
        finally {
            OS.CFRelease(cfstring);
        }
    }

    protected int[] getTypeIds() {
        return new int[]{HTMLID};
    }

    protected String[] getTypeNames() {
        return new String[]{HTML};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

