/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.jdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.text.JavaColorManager;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

class JavaEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.JavaEditorPreferencePage_javaDocKeywords, "java_doc_keyword"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocHtmlTags, "java_doc_tag"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocLinks, "java_doc_link"}, {PreferencesMessages.JavaEditorPreferencePage_javaDocOthers, "java_doc_default"}, {PreferencesMessages.JavaEditorPreferencePage_multiLineComment, "java_multi_line_comment"}, {PreferencesMessages.JavaEditorPreferencePage_singleLineComment, "java_single_line_comment"}, {PreferencesMessages.JavaEditorPreferencePage_javaCommentTaskTags, "java_comment_task_tag"}, {PreferencesMessages.JavaEditorPreferencePage_keywords, "java_keyword"}, {PreferencesMessages.JavaEditorPreferencePage_returnKeyword, "java_keyword_return"}, {PreferencesMessages.JavaEditorPreferencePage_operators, "java_operator"}, {PreferencesMessages.JavaEditorPreferencePage_brackets, "java_bracket"}, {PreferencesMessages.JavaEditorPreferencePage_strings, "java_string"}, {PreferencesMessages.JavaEditorPreferencePage_others, "java_default"}};
    private final String fJavaCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_java;
    private final String fJavadocCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_javadoc;
    private final String fCommentsCategory = PreferencesMessages.JavaEditorPreferencePage_coloring_category_comments;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List<HighlightingColorListItem> fListModel = new ArrayList<HighlightingColorListItem>();
    private TreeViewer fTreeViewer;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private JavaSourceViewer fPreviewViewer;
    private IColorManager fColorManager = new JavaColorManager(false);
    private FontMetrics fFontMetrics;

    public JavaEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[i][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[i][1]) + UNDERLINE));
            ++i;
        }
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i2 = 0;
        int n2 = semanticHighlightings.length;
        while (i2 < n2) {
            this.fListModel.add(new SemanticHighlightingColorListItem(semanticHighlightings[i2].getDisplayName(), SemanticHighlightings.getColorPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getBoldPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getItalicPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightings[i2])));
            ++i2;
        }
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        int n = this.fListModel.size();
        while (i < n) {
            HighlightingColorListItem item = this.fListModel.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item instanceof SemanticHighlightingColorListItem) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)item).getEnableKey()));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Control control = this.createSyntaxPage((Composite)scrolled);
        scrolled.setContent(control);
        Point size = control.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        return scrolled;
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public void initialize() {
        super.initialize();
        this.fTreeViewer.setInput(this.fListModel);
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fJavaCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.uninstallSemanticHighlighting();
        this.installSemanticHighlighting();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        Link link = new Link(colorComposite, 0);
        link.setText(PreferencesMessages.JavaEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("org.eclipse.ui.preferencePages.GeneralTextEditor".equals(e.text)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
                } else if ("org.eclipse.ui.preferencePages.ColorsAndFonts".equals(e.text)) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, (Object)"selectFont:org.eclipse.jdt.ui.editors.textfont");
                }
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(colorComposite, 1);
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fTreeViewer = new TreeViewer(editorComposite, 2052);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (JavaEditorColoringConfigurationBlock.this.fJavaCategory.equals(element)) {
                    return 0;
                }
                if (JavaEditorColoringConfigurationBlock.this.fJavadocCategory.equals(element)) {
                    return 1;
                }
                if (JavaEditorColoringConfigurationBlock.this.fCommentsCategory.equals(element)) {
                    return 2;
                }
                return 0;
            }
        });
        gd = new GridData(1, 1, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        for (HighlightingColorListItem item : this.fListModel) {
            maxWidth = Math.max(maxWidth, this.convertWidthInCharsToPixels(item.getDisplayName().length()));
        }
        ScrollBar vBar = ((Scrollable)this.fTreeViewer.getControl()).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 3;
        }
        gd.widthHint = maxWidth;
        this.fTreeViewer.getControl().setLayoutData((Object)gd);
        this.installDoubleClickListener();
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.JavaEditorPreferencePage_enable);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.JavaEditorPreferencePage_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.JavaEditorPreferencePage_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)JavaEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), JavaEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), JavaEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), JavaEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), JavaEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = JavaEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    JavaEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    JavaEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    JavaEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                    JavaEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    JavaEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        colorComposite.layout(false);
        return colorComposite;
    }

    private void installDoubleClickListener() {
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (JavaEditorColoringConfigurationBlock.this.fTreeViewer.isExpandable(element)) {
                    JavaEditorColoringConfigurationBlock.this.fTreeViewer.setExpandedState(element, !JavaEditorColoringConfigurationBlock.this.fTreeViewer.getExpandedState(element));
                }
            }
        });
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = new JavaSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        SimpleJavaSourceViewerConfiguration configuration = new SimpleJavaSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, "___java_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        configuration.handlePropertyChangeEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jdt.core.compiler.source", (Object)"1.4", (Object)"1.5"));
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        Cursor arrowCursor = this.fPreviewViewer.getTextWidget().getDisplay().getSystemCursor(0);
        this.fPreviewViewer.getTextWidget().setCursor(arrowCursor);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences result = new Preferences();
        result.setValue(COMPILER_TASK_TAGS, "TASK,TODO");
        return result;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    JavaPlugin.log(io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticHighlightingManager == null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager();
            this.fSemanticHighlightingManager.install(this.fPreviewViewer, this.fColorManager, this.getPreferenceStore(), this.createPreviewerRanges());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private SemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new SemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(6, 13, 9, "deprecatedMember"), this.createHighlightedRange(6, 13, 9, "class")}, {this.createHighlightedRange(6, 23, 1, "typeParameter"), this.createHighlightedRange(6, 23, 1, "typeArgument")}, {this.createHighlightedRange(6, 37, 13, "interface")}, {this.createHighlightedRange(6, 51, 6, "typeArgument"), this.createHighlightedRange(6, 51, 6, "class")}, {this.createHighlightedRange(7, 6, 5, "enum")}, {this.createHighlightedRange(7, 14, 3, "staticFinalField"), this.createHighlightedRange(7, 14, 3, "staticField"), this.createHighlightedRange(7, 14, 3, "field")}, {this.createHighlightedRange(7, 19, 5, "staticFinalField"), this.createHighlightedRange(7, 19, 5, "staticField"), this.createHighlightedRange(7, 19, 5, "field")}, {this.createHighlightedRange(7, 26, 4, "staticFinalField"), this.createHighlightedRange(7, 26, 4, "staticField"), this.createHighlightedRange(7, 26, 4, "field")}, {this.createHighlightedRange(9, 8, 6, "class")}, {this.createHighlightedRange(9, 15, 11, "staticField"), this.createHighlightedRange(9, 15, 11, "field")}, {this.createHighlightedRange(11, 9, 1, "typeParameter")}, {this.createHighlightedRange(11, 11, 5, "field")}, {this.createHighlightedRange(12, 9, 17, "abstractClass"), this.createHighlightedRange(12, 9, 17, "class")}, {this.createHighlightedRange(12, 27, 6, "field")}, {this.createHighlightedRange(14, 2, 16, "annotation")}, {this.createHighlightedRange(14, 19, 5, "annotationElementReference")}, {this.createHighlightedRange(15, 12, 3, "methodDeclarationName"), this.createHighlightedRange(15, 12, 3, "method")}, {this.createHighlightedRange(15, 16, 7, "class")}, {this.createHighlightedRange(15, 24, 9, "parameterVariable")}, {this.createHighlightedRange(16, 2, 14, "abstractMethodInvocation"), this.createHighlightedRange(16, 2, 14, "method")}, {this.createHighlightedRange(17, 6, 5, "localVariableDeclaration")}, {this.createHighlightedRange(17, 13, 2, "number")}, {this.createHighlightedRange(17, 16, 8, "inheritedMethodInvocation"), this.createHighlightedRange(17, 16, 8, "method")}, {this.createHighlightedRange(18, 2, 12, "staticMethodInvocation"), this.createHighlightedRange(18, 2, 12, "method")}, {this.createHighlightedRange(19, 9, 3, "method")}, {this.createHighlightedRange(19, 13, 5, "localVariable")}, {this.createHighlightedRange(19, 22, 9, "autoboxing")}};
    }

    private SemanticHighlightingManager.HighlightedRange createHighlightedRange(int line, int column, int length, String key) {
        try {
            IDocument document = this.fPreviewViewer.getDocument();
            int offset = document.getLineOffset(line) + column;
            return new SemanticHighlightingManager.HighlightedRange(offset, length, key);
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)element;
    }

    private void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new String[]{JavaEditorColoringConfigurationBlock.this.fJavaCategory, JavaEditorColoringConfigurationBlock.this.fJavadocCategory, JavaEditorColoringConfigurationBlock.this.fCommentsCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                if (JavaEditorColoringConfigurationBlock.this.fJavaCategory.equals(entry)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(7, JavaEditorColoringConfigurationBlock.this.fListModel.size()).toArray();
                }
                if (JavaEditorColoringConfigurationBlock.this.fJavadocCategory.equals(entry)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(0, 4).toArray();
                }
                if (JavaEditorColoringConfigurationBlock.this.fCommentsCategory.equals(entry)) {
                    return JavaEditorColoringConfigurationBlock.this.fListModel.subList(4, 7).toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            int index = JavaEditorColoringConfigurationBlock.this.fListModel.indexOf(element);
            if (index < 4) {
                return JavaEditorColoringConfigurationBlock.this.fJavadocCategory;
            }
            if (index >= 7) {
                return JavaEditorColoringConfigurationBlock.this.fJavaCategory;
            }
            return JavaEditorColoringConfigurationBlock.this.fCommentsCategory;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((HighlightingColorListItem)element).getDisplayName();
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String enableKey) {
            super(displayName, colorKey, boldKey, italicKey, strikethroughKey, underlineKey);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }
}

