/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.ICommandAccess;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeArgumentMismatchSubProcessor {
    public static void removeMismatchedArguments(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveredNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        ASTNode normalizedNode = ASTNodes.getNormalizedNode(selectedNode);
        if (normalizedNode instanceof ParameterizedType) {
            ASTRewrite rewrite = ASTRewrite.create((AST)normalizedNode.getAST());
            ParameterizedType pt = (ParameterizedType)normalizedNode;
            ASTNode mt = rewrite.createMoveTarget((ASTNode)pt.getType());
            rewrite.replace((ASTNode)pt, mt, null);
            String label = CorrectionMessages.TypeArgumentMismatchSubProcessor_removeTypeArguments;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
    }
}

