/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Tag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.TagAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.IWorkbenchPart;

public class TagOperation
extends RepositoryProviderOperation
implements ITagOperation {
    private Set localOptions = new HashSet();
    private CVSTag tag;

    public TagOperation(IWorkbenchPart part, ResourceMapping[] mappers) {
        super(part, mappers);
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public void setTag(CVSTag tag) {
        this.tag = tag;
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IStatus status = this.tag(provider, resources, recurse, monitor);
        this.collectStatus(status);
    }

    protected String getErrorMessage(IStatus[] problems, int operationCount) {
        if (operationCount == 1) {
            return CVSUIMessages.TagAction_tagProblemsMessage;
        }
        return NLS.bind((String)CVSUIMessages.TagAction_tagProblemsMessageMultiple, (Object[])new String[]{Integer.toString(operationCount - problems.length), Integer.toString(problems.length)});
    }

    public IStatus tag(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor progress) throws CVSException {
        Command.LocalOption[] commandOptions = this.localOptions.toArray(new Command.LocalOption[this.localOptions.size()]);
        if (recurse) {
            commandOptions = Command.DO_NOT_RECURSE.removeFrom(commandOptions);
        } else {
            commandOptions = Command.RECURSE.removeFrom(commandOptions);
            commandOptions = Command.DO_NOT_RECURSE.addTo(commandOptions);
        }
        String[] arguments = this.getStringArguments(resources);
        CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
        Session s = new Session(root.getRemoteLocation(), root.getLocalRoot());
        progress.beginTask(null, 100);
        try {
            s.open(Policy.subMonitorFor(progress, 20), true);
            IStatus iStatus = Command.TAG.execute(s, Command.NO_GLOBAL_OPTIONS, commandOptions, this.tag, arguments, null, Policy.subMonitorFor(progress, 80));
            return iStatus;
        }
        finally {
            s.close();
            progress.done();
        }
    }

    public void addLocalOption(Command.LocalOption option) {
        this.localOptions.add(option);
    }

    public void moveTag() {
        this.addLocalOption(Tag.FORCE_REASSIGNMENT);
    }

    public void doNotRecurse() {
        this.addLocalOption(Command.DO_NOT_RECURSE);
    }

    protected String getTaskName() {
        return CVSUIMessages.TagFromWorkspace_taskName;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.TagOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        super.execute(monitor);
        if (!this.errorsOccurred()) {
            try {
                TagAction.broadcastTagChange(this.getCVSResources(), this.getTag());
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
    }

    private ICVSResource[] getCVSResources() {
        IResource[] resources = this.getTraversalRoots();
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
            ++i;
        }
        return cvsResources;
    }

    public TagSource getTagSource() {
        return TagSource.create((IResource[])this.getProjects());
    }

    private IProject[] getProjects() {
        ResourceMapping[] mappings = this.getSelectedMappings();
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            projects.addAll(Arrays.asList(mapping.getProjects()));
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected boolean isReportableError(IStatus status) {
        return super.isReportableError(status) || status.getCode() == -15;
    }

    public boolean isEmpty() {
        return this.getSelectedMappings().length == 0;
    }
}

