/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.examples.contributions.model.UserSourceProvider;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.services.ISourceProviderService;

public class PersonService
implements IPersonService,
IDisposable {
    private static final int ME = 1114;
    private Map people = new TreeMap();
    private IServiceLocator serviceLocator;
    private ListenerList listeners = new ListenerList(1);
    private static final String[] datafill = new String[]{"Webster", "Paul", "Doe", "John", "Doe", "Jane", "Public", "John", "Public", "Jane"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PersonService(IServiceLocator locator) {
        this.serviceLocator = locator;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.serviceLocator.hasService((Class)clazz);
        this.fillModel();
    }

    private void fillModel() {
        int i = 1114;
        int j = 0;
        while (j < datafill.length) {
            Integer iid;
            Person p;
            if ((p = new Person(iid = new Integer(i++), datafill[j], datafill[j + 1])).getId() == 1114) {
                p.setAdminRights(true);
            }
            this.people.put(iid, p);
            j += 2;
        }
    }

    public void addPersonChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public Collection getPeople() {
        return Collections.unmodifiableCollection(this.people.values());
    }

    public Person getPerson(int id) {
        Person p = (Person)this.people.get(new Integer(id));
        if (p == null) {
            return null;
        }
        return p.copy();
    }

    public void removePersonChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void updatePerson(Person person) {
        Assert.isNotNull((Object)person);
        Person p = (Person)this.people.get(new Integer(person.getId()));
        if (p == null) {
            Assert.isNotNull((Object)p, (String)"Must update a real person");
        }
        if (person.equals(p)) {
            return;
        }
        Person oldVal = p.copy();
        p.setGivenname(person.getGivenname());
        p.setSurname(person.getSurname());
        this.firePersonChange("change", oldVal, person);
    }

    private void firePersonChange(String property, Person oldVal, Person person) {
        if (this.listeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, (Object)oldVal, (Object)person);
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            ((IPropertyChangeListener)array[i]).propertyChange(event);
            ++i;
        }
    }

    public Person createPerson(int id) {
        Integer iid = new Integer(id);
        if (this.people.containsKey(iid)) {
            return null;
        }
        Person person = new Person(id, "surname", "givenname");
        this.people.put(iid, person);
        this.firePersonChange("add", null, person);
        return person;
    }

    public void dispose() {
        this.listeners.clear();
        this.serviceLocator = null;
    }

    public void login(Person person) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.services.ISourceProviderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISourceProviderService sources = (ISourceProviderService)this.serviceLocator.getService((Class)clazz);
        UserSourceProvider userProvider = (UserSourceProvider)sources.getSourceProvider("org.eclipse.ui.examples.contributions.user");
        userProvider.login(person);
    }
}

