/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    Canvas header;
    TreeColumn[] columns = new TreeColumn[0];
    TreeColumn[] orderedColumns;
    TreeItem[] items = NO_ITEMS;
    TreeItem[] availableItems = NO_ITEMS;
    TreeItem[] selectedItems = NO_ITEMS;
    TreeItem focusItem;
    TreeItem anchorItem;
    TreeItem insertMarkItem;
    TreeItem lastClickedItem;
    Color cachedBackground;
    Color cachedForeground;
    Event lastSelectionEvent;
    int availableItemsCount = 0;
    boolean insertMarkPrecedes = false;
    boolean linesVisible;
    boolean ignoreKey;
    boolean ignoreDispose;
    boolean customHeightSet;
    int topIndex = 0;
    int horizontalOffset = 0;
    int fontHeight = 0;
    int imageHeight = 0;
    int itemHeight = 0;
    int headerImageHeight = 0;
    int orderedCol0imageWidth = 0;
    TreeColumn resizeColumn;
    int resizeColumnX = -1;
    int drawCount = 0;
    boolean inExpand = false;
    TreeColumn sortColumn;
    int sortDirection = 0;
    Listener toolTipListener;
    Shell toolTipShell;
    Label toolTipLabel;
    Rectangle arrowBounds;
    Rectangle expanderBounds;
    Rectangle checkboxBounds;
    Rectangle clientArea;
    static final TreeItem[] NO_ITEMS = new TreeItem[0];
    static final int MARGIN_IMAGE = 3;
    static final int MARGIN_CELL = 1;
    static final int SIZE_HORIZONTALSCROLL = 5;
    static final int TOLLERANCE_COLUMNRESIZE = 2;
    static final int WIDTH_HEADER_SHADOW = 2;
    static final int WIDTH_CELL_HIGHLIGHT = 1;
    static final int[] toolTipEvents = new int[]{7, 32, 5, 3};
    static final String ELLIPSIS = "...";
    static final String ID_EXPANDED = "EXPANDED";
    static final String ID_COLLAPSED = "COLLAPSED";
    static final String ID_UNCHECKED = "UNCHECKED";
    static final String ID_GRAYUNCHECKED = "GRAYUNCHECKED";
    static final String ID_CHECKMARK = "CHECKMARK";
    static final String ID_CONNECTOR_COLOR = "CONNECTOR_COLOR";
    static final String ID_ARROWUP = "ARROWUP";
    static final String ID_ARROWDOWN = "ARROWDOWN";
    boolean hasFocus;

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
        ScrollBar vBar;
        this.setForeground(null);
        this.setBackground(null);
        GC gc = new GC(this);
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.itemHeight = this.fontHeight + 2 * this.getCellPadding();
        Tree.initImages(this.display);
        this.expanderBounds = this.getExpandedImage().getBounds();
        this.checkboxBounds = this.getUncheckedImage().getBounds();
        this.arrowBounds = this.getArrowDownImage().getBounds();
        this.clientArea = this.getClientArea();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Tree.this.handleEvents(event);
            }
        };
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(8, listener);
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.addListener(1, listener);
        this.addListener(16, listener);
        this.addListener(15, listener);
        this.addListener(31, listener);
        this.header = new Canvas(this, 0x180000);
        this.header.setVisible(false);
        this.header.setBounds(0, 0, 0, this.fontHeight + 2 * this.getHeaderPadding());
        this.header.addListener(9, listener);
        this.header.addListener(3, listener);
        this.header.addListener(4, listener);
        this.header.addListener(32, listener);
        this.header.addListener(8, listener);
        this.header.addListener(5, listener);
        this.header.addListener(7, listener);
        this.header.addListener(35, listener);
        this.toolTipListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 32: {
                        if (Tree.this.headerUpdateToolTip(event.x)) break;
                    }
                    case 3: 
                    case 7: {
                        Tree.this.headerHideToolTip();
                    }
                }
            }
        };
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setValues(0, 0, 1, 1, 1, 1);
            hBar.setVisible(false);
            hBar.addListener(13, listener);
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.setValues(0, 0, 1, 1, 1, 1);
            vBar.setVisible(false);
            vBar.addListener(13, listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    boolean checkData(TreeItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            TreeItem parentItem = item.getParentItem();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            this.sendEvent(36, event);
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw) {
                this.redrawItem(item.availableIndex, false);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        style |= 0x20140000;
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Tree.error(43);
        }
    }

    public void clear(int index, boolean recursive) {
        Rectangle bounds;
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            Tree.error(6);
        }
        TreeItem item = this.items[index];
        TreeItem[] availableDescendents = null;
        int oldRightX = 0;
        if (this.columns.length == 0) {
            if (recursive) {
                availableDescendents = item.computeAvailableDescendents();
                int i = 0;
                while (i < availableDescendents.length) {
                    bounds = availableDescendents[i].getBounds(false);
                    oldRightX = Math.max(oldRightX, bounds.x + bounds.width);
                    ++i;
                }
            } else {
                Rectangle bounds2 = item.getBounds(false);
                oldRightX = bounds2.x + bounds2.width;
            }
        }
        item.clear();
        if (recursive) {
            item.clearAll(true, false);
        }
        if (this.columns.length == 0) {
            int newRightX = 0;
            if (recursive) {
                int i = 0;
                while (i < availableDescendents.length) {
                    Rectangle bounds3 = availableDescendents[i].getBounds(false);
                    newRightX = Math.max(newRightX, bounds3.x + bounds3.width);
                    ++i;
                }
            } else {
                bounds = item.getBounds(false);
                newRightX = bounds.x + bounds.width;
            }
            this.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
        if (recursive && item.expanded) {
            int descendentCount = availableDescendents == null ? item.computeAvailableDescendentCount() : availableDescendents.length;
            this.redrawItems(item.availableIndex, item.availableIndex + descendentCount - 1, false);
        } else {
            this.redrawItem(item.availableIndex, false);
        }
    }

    public void clearAll(boolean recursive) {
        int i;
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        int oldRightX = 0;
        if (this.columns.length == 0 && !recursive) {
            i = 0;
            while (i < this.items.length) {
                Rectangle bounds = this.items[i].getBounds(false);
                oldRightX = Math.max(oldRightX, bounds.x + bounds.width);
                ++i;
            }
        }
        i = 0;
        while (i < this.items.length) {
            this.items[i].clear();
            if (recursive) {
                this.items[i].clearAll(true, false);
            }
            ++i;
        }
        if (this.columns.length == 0) {
            if (recursive) {
                this.updateHorizontalBar();
            } else {
                Rectangle bounds = this.items[0].getBounds(false);
                int newRightX = bounds.x + bounds.width;
                this.updateHorizontalBar(newRightX, newRightX - oldRightX);
            }
        }
        if (recursive) {
            this.redrawItems(0, this.availableItemsCount - 1, false);
        } else {
            i = 0;
            while (i < this.items.length) {
                this.redrawItem(this.items[i].availableIndex, false);
                ++i;
            }
        }
    }

    int computeColumnIntersect(int x, int startColumn) {
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        if (orderedColumns.length - 1 < startColumn) {
            return -1;
        }
        int rightX = orderedColumns[startColumn].getX();
        int i = startColumn;
        while (i < orderedColumns.length) {
            if (x < (rightX += orderedColumns[i].width)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint != -1) {
            width = wHint;
        } else if (this.columns.length == 0) {
            int i = 0;
            while (i < this.availableItemsCount) {
                Rectangle itemBounds = this.availableItems[i].getBounds(false);
                width = Math.max(width, itemBounds.x + itemBounds.width);
                ++i;
            }
        } else {
            TreeColumn[] orderedColumns = this.getOrderedColumns();
            TreeColumn lastColumn = orderedColumns[orderedColumns.length - 1];
            width = lastColumn.getX() + lastColumn.width;
        }
        height = hHint != -1 ? hHint : this.getHeaderHeight() + this.availableItemsCount * this.itemHeight;
        Rectangle result = this.computeTrim(0, 0, width, height);
        return new Point(result.width, result.height);
    }

    void createItem(TreeColumn column, int index) {
        TreeColumn[] newColumns = new TreeColumn[this.columns.length + 1];
        System.arraycopy(this.columns, 0, newColumns, 0, index);
        newColumns[index] = column;
        System.arraycopy(this.columns, index, newColumns, index + 1, this.columns.length - index);
        this.columns = newColumns;
        if (this.orderedColumns != null) {
            int insertIndex = 0;
            if (index > 0) {
                insertIndex = this.columns[index - 1].getOrderIndex() + 1;
            }
            TreeColumn[] newOrderedColumns = new TreeColumn[this.orderedColumns.length + 1];
            System.arraycopy(this.orderedColumns, 0, newOrderedColumns, 0, insertIndex);
            newOrderedColumns[insertIndex] = column;
            System.arraycopy(this.orderedColumns, insertIndex, newOrderedColumns, insertIndex + 1, this.orderedColumns.length - insertIndex);
            this.orderedColumns = newOrderedColumns;
        }
        if (this.columns.length == 1) {
            column.itemImageWidth = this.orderedCol0imageWidth;
        } else if (column.getOrderIndex() == 0) {
            this.orderedCol0imageWidth = 0;
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].addColumn(column);
            ++i;
        }
        if (this.columns.length == 1 && this.availableItemsCount > 0) {
            this.redrawFromItemDownwards(this.topIndex);
        } else if (this.availableItemsCount > 0 && (this.style & 0x20) != 0 && index == 0 && column.getOrderIndex() == 0) {
            this.redrawFromItemDownwards(this.topIndex);
        }
    }

    void createItem(TreeItem item, int index) {
        TreeItem[] newItems = new TreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, index);
        newItems[index] = item;
        System.arraycopy(this.items, index, newItems, index + 1, this.items.length - index);
        this.items = newItems;
        int startIndex = index == this.items.length - 1 ? this.availableItemsCount : this.items[index + 1].availableIndex;
        if (this.availableItemsCount == this.availableItems.length) {
            int grow = this.drawCount <= 0 ? 4 : Math.max(4, this.availableItems.length * 3 / 2);
            TreeItem[] newAvailableItems = new TreeItem[this.availableItems.length + grow];
            System.arraycopy(this.availableItems, 0, newAvailableItems, 0, this.availableItems.length);
            this.availableItems = newAvailableItems;
        }
        if (startIndex != this.availableItemsCount) {
            System.arraycopy(this.availableItems, startIndex, this.availableItems, startIndex + 1, this.availableItemsCount - startIndex);
        }
        this.availableItems[startIndex] = item;
        ++this.availableItemsCount;
        int i = startIndex;
        while (i < this.availableItemsCount) {
            this.availableItems[i].availableIndex = i;
            ++i;
        }
        this.updateVerticalBar();
        Rectangle bounds = item.getBounds(false);
        int rightX = bounds.x + bounds.width;
        this.updateHorizontalBar(rightX, rightX);
        if (item.availableIndex < this.topIndex) {
            ++this.topIndex;
            ScrollBar vBar = this.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(this.topIndex);
            }
            return;
        }
        if (this.availableItemsCount == 1 && this.isFocusControl()) {
            this.focusItem = item;
            this.redraw();
            return;
        }
        int redrawIndex = index;
        if (redrawIndex > 0 && item.isLastChild()) {
            --redrawIndex;
        }
        this.redrawFromItemDownwards(this.items[redrawIndex].availableIndex);
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        this.deselectItem(item);
        this.redrawItem(item.availableIndex, true);
    }

    public void deselectAll() {
        this.checkWidget();
        TreeItem[] oldSelection = this.selectedItems;
        this.selectedItems = NO_ITEMS;
        int i = 0;
        while (i < oldSelection.length) {
            this.redrawItem(oldSelection[i].availableIndex, true);
            ++i;
        }
    }

    void deselectItem(TreeItem item) {
        int index = this.getSelectionIndex(item);
        if (index == -1) {
            return;
        }
        TreeItem[] newSelectedItems = new TreeItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, index);
        System.arraycopy(this.selectedItems, index + 1, newSelectedItems, index, newSelectedItems.length - index);
        this.selectedItems = newSelectedItems;
    }

    void destroyItem(TreeColumn column) {
        this.headerHideToolTip();
        int index = column.getIndex();
        int orderedIndex = column.getOrderIndex();
        TreeColumn[] newColumns = new TreeColumn[this.columns.length - 1];
        System.arraycopy(this.columns, 0, newColumns, 0, index);
        System.arraycopy(this.columns, index + 1, newColumns, index, newColumns.length - index);
        this.columns = newColumns;
        if (this.orderedColumns != null) {
            if (this.columns.length < 2) {
                this.orderedColumns = null;
            } else {
                int removeIndex = column.getOrderIndex();
                TreeColumn[] newOrderedColumns = new TreeColumn[this.orderedColumns.length - 1];
                System.arraycopy(this.orderedColumns, 0, newOrderedColumns, 0, removeIndex);
                System.arraycopy(this.orderedColumns, removeIndex + 1, newOrderedColumns, removeIndex, newOrderedColumns.length - removeIndex);
                this.orderedColumns = newOrderedColumns;
            }
        }
        if (orderedIndex == 0 && this.columns.length > 0) {
            this.orderedCol0imageWidth = this.columns[this.getColumnOrder()[0]].itemImageWidth;
        }
        int i = 0;
        while (i < this.items.length) {
            this.items[i].removeColumn(column, index, orderedIndex);
            ++i;
        }
        int lastColumnIndex = this.columns.length - 1;
        if (lastColumnIndex < 0) {
            this.updateHorizontalBar();
        } else {
            int newWidth = 0;
            int i2 = 0;
            while (i2 < this.columns.length) {
                newWidth += this.columns[i2].width;
                ++i2;
            }
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setMaximum(newWidth);
                hBar.setVisible(this.clientArea.width < newWidth);
                int selection = hBar.getSelection();
                if (selection != this.horizontalOffset) {
                    this.horizontalOffset = selection;
                    this.redraw();
                    if (this.header.isVisible() && this.drawCount <= 0) {
                        this.header.redraw();
                    }
                }
            }
        }
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int i3 = orderedIndex;
        while (i3 < orderedColumns.length) {
            if (!orderedColumns[i3].isDisposed()) {
                orderedColumns[i3].sendEvent(10);
            }
            ++i3;
        }
        if (this.sortColumn == column) {
            this.sortColumn = null;
        }
    }

    void destroyItem(TreeItem item) {
        int availableIndex;
        if (item == this.focusItem) {
            this.reassignFocus();
        }
        if ((availableIndex = item.availableIndex) != -1) {
            Rectangle bounds = item.getBounds(false);
            int rightX = bounds.x + bounds.width;
            if (availableIndex != this.availableItemsCount - 1) {
                System.arraycopy(this.availableItems, availableIndex + 1, this.availableItems, availableIndex, this.availableItemsCount - availableIndex - 1);
                this.availableItems[this.availableItemsCount - 1] = null;
            } else {
                this.availableItems[availableIndex] = null;
            }
            --this.availableItemsCount;
            if (this.drawCount <= 0 && this.availableItems.length - this.availableItemsCount == 4) {
                TreeItem[] newAvailableItems = new TreeItem[this.availableItemsCount];
                System.arraycopy(this.availableItems, 0, newAvailableItems, 0, newAvailableItems.length);
                this.availableItems = newAvailableItems;
            }
            int i = availableIndex;
            while (i < this.availableItemsCount) {
                this.availableItems[i].availableIndex = i;
                ++i;
            }
            item.availableIndex = -1;
            int oldTopIndex = this.topIndex;
            this.updateVerticalBar();
            this.updateHorizontalBar(0, -rightX);
            if (availableIndex < this.topIndex) {
                this.topIndex = oldTopIndex - 1;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
            }
        }
        if (item.isSelected()) {
            int selectionIndex = this.getSelectionIndex(item);
            TreeItem[] newSelectedItems = new TreeItem[this.selectedItems.length - 1];
            System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, selectionIndex);
            System.arraycopy(this.selectedItems, selectionIndex + 1, newSelectedItems, selectionIndex, newSelectedItems.length - selectionIndex);
            this.selectedItems = newSelectedItems;
        }
        if (item.depth == 0) {
            int index = item.getIndex();
            TreeItem[] newItems = new TreeItem[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, newItems.length - index);
            this.items = newItems;
        }
        if (item == this.anchorItem) {
            this.anchorItem = null;
        }
        if (item == this.insertMarkItem) {
            this.insertMarkItem = null;
        }
        if (item == this.lastClickedItem) {
            this.lastClickedItem = null;
        }
        if (this.availableItemsCount == 0 && this.isFocusControl()) {
            this.redraw();
            return;
        }
    }

    Image getArrowDownImage() {
        return (Image)this.display.getData(ID_ARROWDOWN);
    }

    Image getArrowUpImage() {
        return (Image)this.display.getData(ID_ARROWUP);
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.cachedBackground != null) {
            return this.cachedBackground;
        }
        return super.getBackground();
    }

    int getCellPadding() {
        return 2;
    }

    Image getCheckmarkImage() {
        return (Image)this.display.getData(ID_CHECKMARK);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controls = this._getChildren();
        if (this.header == null) {
            return controls;
        }
        Control[] result = new Control[controls.length - 1];
        int index = 0;
        int i = 0;
        while (i < controls.length) {
            if (controls[i] != this.header) {
                result[index++] = controls[i];
            }
            ++i;
        }
        return result;
    }

    Image getCollapsedImage() {
        return (Image)this.display.getData(ID_COLLAPSED);
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columns.length) {
            Tree.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.length;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] result = new int[this.columns.length];
        if (this.orderedColumns != null) {
            int i = 0;
            while (i < result.length) {
                result[i] = this.orderedColumns[i].getIndex();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.columns.length) {
                result[i] = i;
                ++i;
            }
        }
        return result;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columns.length];
        System.arraycopy(this.columns, 0, result, 0, this.columns.length);
        return result;
    }

    Color getConnectorColor() {
        return (Color)this.display.getData(ID_CONNECTOR_COLOR);
    }

    Image getExpandedImage() {
        return (Image)this.display.getData(ID_EXPANDED);
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.cachedForeground != null) {
            return this.cachedForeground;
        }
        return super.getForeground();
    }

    Image getGrayUncheckedImage() {
        return (Image)this.display.getData(ID_GRAYUNCHECKED);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.header.getVisible()) {
            return 0;
        }
        return this.header.getSize().y;
    }

    int getHeaderPadding() {
        return 3;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.header.getVisible();
    }

    public TreeItem getItem(Point point) {
        int index;
        this.checkWidget();
        if (point == null) {
            Tree.error(4);
        }
        if ((index = (point.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.availableItemsCount) {
            return null;
        }
        TreeItem result = this.availableItems[index];
        if (!result.getHitBounds().contains(point)) {
            return null;
        }
        return result;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.length) {
            Tree.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.itemHeight;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    int getItemY(TreeItem item) {
        int index = item.availableIndex;
        if (index == -1) {
            return -1;
        }
        return (index - this.topIndex) * this.itemHeight + this.getHeaderHeight();
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    TreeColumn[] getOrderedColumns() {
        if (this.orderedColumns != null) {
            return this.orderedColumns;
        }
        return this.columns;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int count = this.selectedItems.length;
        TreeItem[] result = new TreeItem[count];
        if (count > 0) {
            if (count == 1) {
                System.arraycopy(this.selectedItems, 0, result, 0, count);
            } else {
                this.getSelection(result, this.items, 0);
            }
        }
        return result;
    }

    int getSelection(TreeItem[] result, TreeItem[] items, int index) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item.isSelected()) {
                result[index++] = item;
            }
            if (index == result.length || (index = this.getSelection(result, items[i].items, index)) == result.length) break;
            ++i;
        }
        return index;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selectedItems.length;
    }

    int getSelectionIndex(TreeItem item) {
        int i = 0;
        while (i < this.selectedItems.length) {
            if (this.selectedItems[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        if (this.availableItemsCount == 0) {
            return null;
        }
        return this.availableItems[this.topIndex];
    }

    Image getUncheckedImage() {
        return (Image)this.display.getData(ID_UNCHECKED);
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 9: {
                if (event.widget == this.header) {
                    this.headerOnPaint(event);
                    break;
                }
                this.onPaint(event);
                break;
            }
            case 35: {
                this.notifyListeners(35, event);
                break;
            }
            case 3: {
                if (event.widget == this.header) {
                    this.headerOnMouseDown(event);
                    break;
                }
                this.onMouseDown(event);
                break;
            }
            case 4: {
                if (event.widget == this.header) {
                    this.headerOnMouseUp(event);
                    break;
                }
                this.onMouseUp(event);
                break;
            }
            case 32: {
                this.headerOnMouseHover(event);
                break;
            }
            case 5: {
                this.headerOnMouseMove(event);
                break;
            }
            case 8: {
                if (event.widget == this.header) {
                    this.headerOnMouseDoubleClick(event);
                    break;
                }
                this.onMouseDoubleClick(event);
                break;
            }
            case 7: {
                this.headerOnMouseExit();
                break;
            }
            case 12: {
                this.onDispose(event);
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 11: {
                this.onResize(event);
                break;
            }
            case 13: {
                if (event.widget == this.getHorizontalBar()) {
                    this.onScrollHorizontal(event);
                }
                if (event.widget != this.getVerticalBar()) break;
                this.onScrollVertical(event);
                break;
            }
            case 16: {
                this.onFocusOut();
                break;
            }
            case 15: {
                this.onFocusIn();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                    }
                }
            }
        }
    }

    String headerGetToolTip(int x) {
        int columnRightX;
        if (this.resizeColumn != null) {
            return null;
        }
        int orderedIndex = this.computeColumnIntersect(x, 0);
        if (orderedIndex == -1) {
            return null;
        }
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        TreeColumn column = orderedColumns[orderedIndex];
        if (column.toolTipText == null) {
            return null;
        }
        int columnX = column.getX();
        if (orderedIndex > 0 && orderedColumns[orderedIndex - 1].resizable && x - columnX <= 2) {
            return null;
        }
        if (column.resizable && (columnRightX = columnX + column.width) - x <= 2) {
            return null;
        }
        return this.removeMnemonics(column.toolTipText);
    }

    void headerHideToolTip() {
        if (this.toolTipShell == null) {
            return;
        }
        int i = 0;
        while (i < toolTipEvents.length) {
            this.header.removeListener(toolTipEvents[i], this.toolTipListener);
            ++i;
        }
        this.toolTipShell.dispose();
        this.toolTipShell = null;
        this.toolTipLabel = null;
    }

    void headerOnMouseDoubleClick(Event event) {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if (this.columns.length == 0) {
            return;
        }
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int x = -this.horizontalOffset;
        int i = 0;
        while (i < orderedColumns.length) {
            TreeColumn column = orderedColumns[i];
            if (event.x < (x += column.width)) {
                TreeColumn packColumn = null;
                if (x - event.x <= 2) {
                    packColumn = column;
                } else if (i > 0 && event.x - column.getX() <= 2) {
                    packColumn = orderedColumns[i - 1];
                }
                if (packColumn != null) {
                    packColumn.pack();
                    this.resizeColumn = null;
                    if (Math.abs(packColumn.getX() + packColumn.width - event.x) > 2) {
                        this.setCursor(null);
                    }
                    return;
                }
                Event newEvent = new Event();
                newEvent.widget = column;
                column.postEvent(14, newEvent);
                return;
            }
            ++i;
        }
    }

    void headerOnMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int x = -this.horizontalOffset;
        int i = 0;
        while (i < orderedColumns.length) {
            TreeColumn column = orderedColumns[i];
            if (column.resizable && Math.abs((x += column.width) - event.x) <= 2) {
                this.resizeColumn = column;
                this.resizeColumnX = x;
                return;
            }
            if (event.x < x) {
                if (column.moveable) {
                    int columnX = column.getX();
                    int pointerOffset = event.x - columnX;
                    this.headerHideToolTip();
                    Tracker tracker = new Tracker(this, 0);
                    tracker.setRectangles(new Rectangle[]{new Rectangle(columnX, 0, column.width, this.getHeaderHeight())});
                    if (!tracker.open()) {
                        return;
                    }
                    Rectangle result = tracker.getRectangles()[0];
                    int pointerX = result.x + pointerOffset;
                    if (pointerX < 0) {
                        return;
                    }
                    x = -this.horizontalOffset;
                    int destIndex = 0;
                    while (destIndex < orderedColumns.length) {
                        TreeColumn destColumn = orderedColumns[destIndex];
                        if (pointerX < (x += destColumn.width)) {
                            int oldIndex = column.getOrderIndex();
                            if (destIndex == oldIndex) {
                                Event newEvent = new Event();
                                newEvent.widget = column;
                                column.postEvent(13, newEvent);
                                return;
                            }
                            int leftmostIndex = Math.min(destIndex, oldIndex);
                            int[] oldOrder = this.getColumnOrder();
                            int[] newOrder = new int[oldOrder.length];
                            System.arraycopy(oldOrder, 0, newOrder, 0, leftmostIndex);
                            if (leftmostIndex == oldIndex) {
                                System.arraycopy(oldOrder, oldIndex + 1, newOrder, oldIndex, destIndex - oldIndex);
                            } else {
                                System.arraycopy(oldOrder, destIndex, newOrder, destIndex + 1, oldIndex - destIndex);
                            }
                            newOrder[destIndex] = oldOrder[oldIndex];
                            int rightmostIndex = Math.max(destIndex, oldIndex);
                            System.arraycopy(oldOrder, rightmostIndex + 1, newOrder, rightmostIndex + 1, newOrder.length - rightmostIndex - 1);
                            this.setColumnOrder(newOrder);
                            return;
                        }
                        ++destIndex;
                    }
                    return;
                }
                Event newEvent = new Event();
                newEvent.widget = column;
                column.postEvent(13, newEvent);
                return;
            }
            ++i;
        }
    }

    void headerOnMouseExit() {
        if (this.resizeColumn != null) {
            return;
        }
        this.setCursor(null);
    }

    void headerOnMouseHover(Event event) {
        this.headerShowToolTip(event.x);
    }

    void headerOnMouseMove(Event event) {
        if (this.resizeColumn == null) {
            int i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                int x = column.getX() + column.width;
                if (Math.abs(x - event.x) <= 2) {
                    if (column.resizable) {
                        this.setCursor(this.display.getSystemCursor(9));
                    } else {
                        this.setCursor(null);
                    }
                    return;
                }
                ++i;
            }
            this.setCursor(null);
            return;
        }
        if (event.x <= this.resizeColumn.getX()) {
            return;
        }
        GC gc = new GC(this);
        gc.setForeground(this.display.getSystemColor(2));
        int lineHeight = this.clientArea.height;
        this.redraw(this.resizeColumnX - 1, 0, 1, lineHeight, false);
        this.resizeColumnX = event.x;
        gc.drawLine(this.resizeColumnX - 1, 0, this.resizeColumnX - 1, lineHeight);
        gc.dispose();
    }

    void headerOnMouseUp(Event event) {
        if (this.resizeColumn == null) {
            return;
        }
        GC gc = new GC(this);
        this.redraw(this.resizeColumnX - 1, 0, 1, this.clientArea.height, false);
        gc.dispose();
        int newWidth = this.resizeColumnX - this.resizeColumn.getX();
        if (newWidth != this.resizeColumn.width) {
            this.setCursor(null);
            this.updateColumnWidth(this.resizeColumn, newWidth);
        }
        this.resizeColumnX = -1;
        this.resizeColumn = null;
    }

    void headerOnPaint(Event event) {
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int numColumns = orderedColumns.length;
        GC gc = event.gc;
        Rectangle clipping = gc.getClipping();
        int startColumn = -1;
        int endColumn = -1;
        if (numColumns > 0) {
            startColumn = this.computeColumnIntersect(clipping.x, 0);
            if (startColumn != -1 && (endColumn = this.computeColumnIntersect(clipping.x + clipping.width, startColumn)) == -1) {
                endColumn = numColumns - 1;
            }
        } else {
            endColumn = 0;
            startColumn = 0;
        }
        Point headerSize = this.header.getSize();
        this.headerPaintHShadows(gc, 0, 0, headerSize.x, headerSize.y);
        if (startColumn == -1) {
            return;
        }
        if (numColumns == 0) {
            return;
        }
        int i = startColumn;
        while (i <= endColumn) {
            this.headerPaintVShadows(gc, orderedColumns[i].getX(), 0, orderedColumns[i].width, headerSize.y);
            orderedColumns[i].paint(gc);
            ++i;
        }
    }

    void headerPaintHShadows(GC gc, int x, int y, int width, int height) {
        gc.setClipping(x, y, width, height);
        int endX = x + width;
        gc.setForeground(this.display.getSystemColor(20));
        gc.drawLine(x, y, endX, y);
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(x, height - 2, endX, height - 2);
        gc.setForeground(this.display.getSystemColor(17));
        gc.drawLine(x, height - 1, endX, height - 1);
    }

    void headerPaintVShadows(GC gc, int x, int y, int width, int height) {
        gc.setClipping(x, y, width, height);
        int endX = x + width;
        gc.setForeground(this.display.getSystemColor(20));
        gc.drawLine(x, y, x, y + height - 1);
        gc.setForeground(this.display.getSystemColor(18));
        gc.drawLine(endX - 2, y + 1, endX - 2, height - 2);
        gc.setForeground(this.display.getSystemColor(17));
        gc.drawLine(endX - 1, y, endX - 1, height - 1);
    }

    void headerShowToolTip(int x) {
        String tooltip = this.headerGetToolTip(x);
        if (tooltip == null || tooltip.length() == 0) {
            return;
        }
        if (this.toolTipShell == null) {
            this.toolTipShell = new Shell(this.getShell(), 16388);
            this.toolTipLabel = new Label(this.toolTipShell, 0x1000000);
            Display display = this.toolTipShell.getDisplay();
            this.toolTipLabel.setForeground(display.getSystemColor(28));
            this.toolTipLabel.setBackground(display.getSystemColor(29));
            int i = 0;
            while (i < toolTipEvents.length) {
                this.header.addListener(toolTipEvents[i], this.toolTipListener);
                ++i;
            }
        }
        if (this.headerUpdateToolTip(x)) {
            this.toolTipShell.setVisible(true);
        } else {
            this.headerHideToolTip();
        }
    }

    boolean headerUpdateToolTip(int x) {
        String tooltip = this.headerGetToolTip(x);
        if (tooltip == null || tooltip.length() == 0) {
            return false;
        }
        if (tooltip.equals(this.toolTipLabel.getText())) {
            return true;
        }
        this.toolTipLabel.setText(tooltip);
        TreeColumn column = this.getOrderedColumns()[this.computeColumnIntersect(x, 0)];
        this.toolTipShell.setData(new Integer(column.getIndex()));
        Point labelSize = this.toolTipLabel.computeSize(-1, -1, true);
        labelSize.x += 2;
        labelSize.y += 2;
        this.toolTipLabel.setSize(labelSize);
        this.toolTipShell.pack();
        Rectangle area = this.toolTipShell.getClientArea();
        this.toolTipLabel.setSize(area.width, area.height);
        Point cursorLocation = this.getDisplay().getCursorLocation();
        int cursorHeight = 21;
        Point size = this.toolTipShell.getSize();
        Rectangle rect = this.getMonitor().getBounds();
        Point pt = new Point(cursorLocation.x, cursorLocation.y + cursorHeight + 2);
        pt.x = Math.max(pt.x, rect.x);
        if (pt.x + size.x > rect.x + rect.width) {
            pt.x = rect.x + rect.width - size.x;
        }
        if (pt.y + size.y > rect.y + rect.height) {
            pt.y = cursorLocation.y - 2 - size.y;
        }
        this.toolTipShell.setLocation(pt);
        return true;
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            Tree.error(4);
        }
        if (column.isDisposed()) {
            Tree.error(5);
        }
        return column.getIndex();
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        if (item.parentItem != null || item.parent != this) {
            return -1;
        }
        return item.getIndex();
    }

    static void initImages(final Display display) {
        PaletteData fourBit = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)});
        if (display.getData(ID_EXPANDED) == null) {
            byte[] byArray = new byte[72];
            byArray[0] = 119;
            byArray[1] = 119;
            byArray[2] = 119;
            byArray[3] = 119;
            byArray[4] = 112;
            byArray[8] = 127;
            byArray[9] = -1;
            byArray[10] = -1;
            byArray[11] = -1;
            byArray[12] = 112;
            byArray[16] = 127;
            byArray[17] = -1;
            byArray[18] = -1;
            byArray[19] = -1;
            byArray[20] = 112;
            byArray[24] = 127;
            byArray[25] = -1;
            byArray[26] = -1;
            byArray[27] = -1;
            byArray[28] = 112;
            byArray[32] = 127;
            byArray[35] = 15;
            byArray[36] = 112;
            byArray[40] = 127;
            byArray[41] = -1;
            byArray[42] = -1;
            byArray[43] = -1;
            byArray[44] = 112;
            byArray[48] = 127;
            byArray[49] = -1;
            byArray[50] = -1;
            byArray[51] = -1;
            byArray[52] = 112;
            byArray[56] = 127;
            byArray[57] = -1;
            byArray[58] = -1;
            byArray[59] = -1;
            byArray[60] = 112;
            byArray[64] = 119;
            byArray[65] = 119;
            byArray[66] = 119;
            byArray[67] = 119;
            byArray[68] = 112;
            ImageData expanded = new ImageData(9, 9, 4, fourBit, 4, byArray);
            expanded.transparentPixel = 15;
            display.setData(ID_EXPANDED, new Image((Device)display, expanded));
        }
        if (display.getData(ID_COLLAPSED) == null) {
            byte[] byArray = new byte[72];
            byArray[0] = 119;
            byArray[1] = 119;
            byArray[2] = 119;
            byArray[3] = 119;
            byArray[4] = 112;
            byArray[8] = 127;
            byArray[9] = -1;
            byArray[10] = -1;
            byArray[11] = -1;
            byArray[12] = 112;
            byArray[16] = 127;
            byArray[17] = -1;
            byArray[18] = 15;
            byArray[19] = -1;
            byArray[20] = 112;
            byArray[24] = 127;
            byArray[25] = -1;
            byArray[26] = 15;
            byArray[27] = -1;
            byArray[28] = 112;
            byArray[32] = 127;
            byArray[35] = 15;
            byArray[36] = 112;
            byArray[40] = 127;
            byArray[41] = -1;
            byArray[42] = 15;
            byArray[43] = -1;
            byArray[44] = 112;
            byArray[48] = 127;
            byArray[49] = -1;
            byArray[50] = 15;
            byArray[51] = -1;
            byArray[52] = 112;
            byArray[56] = 127;
            byArray[57] = -1;
            byArray[58] = -1;
            byArray[59] = -1;
            byArray[60] = 112;
            byArray[64] = 119;
            byArray[65] = 119;
            byArray[66] = 119;
            byArray[67] = 119;
            byArray[68] = 112;
            ImageData collapsed = new ImageData(9, 9, 4, fourBit, 4, byArray);
            collapsed.transparentPixel = 15;
            display.setData(ID_COLLAPSED, new Image((Device)display, collapsed));
        }
        PaletteData arrowPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        if (display.getData(ID_ARROWDOWN) == null) {
            byte[] byArray = new byte[4];
            byArray[1] = -125;
            byArray[2] = -57;
            byArray[3] = -17;
            ImageData arrowDown = new ImageData(7, 4, 1, arrowPalette, 1, byArray);
            arrowDown.transparentPixel = 1;
            display.setData(ID_ARROWDOWN, new Image((Device)display, arrowDown));
        }
        if (display.getData(ID_ARROWUP) == null) {
            byte[] byArray = new byte[4];
            byArray[0] = -17;
            byArray[1] = -57;
            byArray[2] = -125;
            ImageData arrowUp = new ImageData(7, 4, 1, arrowPalette, 1, byArray);
            arrowUp.transparentPixel = 1;
            display.setData(ID_ARROWUP, new Image((Device)display, arrowUp));
        }
        PaletteData checkMarkPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(252, 3, 251)});
        byte[] byArray = new byte[22];
        byArray[2] = 127;
        byArray[3] = -64;
        byArray[4] = 127;
        byArray[5] = -64;
        byArray[6] = 127;
        byArray[7] = -64;
        byArray[8] = 127;
        byArray[9] = -64;
        byArray[10] = 127;
        byArray[11] = -64;
        byArray[12] = 127;
        byArray[13] = -64;
        byArray[14] = 127;
        byArray[15] = -64;
        byArray[16] = 127;
        byArray[17] = -64;
        byArray[18] = 127;
        byArray[19] = -64;
        byte[] checkbox = byArray;
        ImageData checkmark = new ImageData(7, 7, 1, checkMarkPalette, 1, new byte[]{-4, -8, 112, 34, 6, -114, -34});
        checkmark.transparentPixel = 1;
        if (display.getData(ID_CHECKMARK) == null) {
            display.setData(ID_CHECKMARK, new Image((Device)display, checkmark));
        }
        if (display.getData(ID_UNCHECKED) == null) {
            PaletteData uncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(255, 255, 255)});
            ImageData unchecked = new ImageData(11, 11, 1, uncheckedPalette, 2, checkbox);
            display.setData(ID_UNCHECKED, new Image((Device)display, unchecked));
        }
        if (display.getData(ID_GRAYUNCHECKED) == null) {
            PaletteData grayUncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(192, 192, 192)});
            ImageData grayUnchecked = new ImageData(11, 11, 1, grayUncheckedPalette, 2, checkbox);
            display.setData(ID_GRAYUNCHECKED, new Image((Device)display, grayUnchecked));
        }
        if (display.getData(ID_CONNECTOR_COLOR) == null) {
            display.setData(ID_CONNECTOR_COLOR, new Color(display, 170, 170, 170));
        }
        display.disposeExec(new Runnable(){

            public void run() {
                Image arrowUp;
                Image arrowDown;
                Image checkmark;
                Image grayUnchecked;
                Image unchecked;
                Color connectorColor;
                Image collapsed;
                Image expanded = (Image)display.getData(Tree.ID_EXPANDED);
                if (expanded != null) {
                    expanded.dispose();
                }
                if ((collapsed = (Image)display.getData(Tree.ID_COLLAPSED)) != null) {
                    collapsed.dispose();
                }
                if ((connectorColor = (Color)display.getData(Tree.ID_CONNECTOR_COLOR)) != null) {
                    connectorColor.dispose();
                }
                if ((unchecked = (Image)display.getData(Tree.ID_UNCHECKED)) != null) {
                    unchecked.dispose();
                }
                if ((grayUnchecked = (Image)display.getData(Tree.ID_GRAYUNCHECKED)) != null) {
                    grayUnchecked.dispose();
                }
                if ((checkmark = (Image)display.getData(Tree.ID_CHECKMARK)) != null) {
                    checkmark.dispose();
                }
                if ((arrowDown = (Image)display.getData(Tree.ID_ARROWDOWN)) != null) {
                    arrowDown.dispose();
                }
                if ((arrowUp = (Image)display.getData(Tree.ID_ARROWUP)) != null) {
                    arrowUp.dispose();
                }
                display.setData(Tree.ID_EXPANDED, null);
                display.setData(Tree.ID_COLLAPSED, null);
                display.setData(Tree.ID_CONNECTOR_COLOR, null);
                display.setData(Tree.ID_UNCHECKED, null);
                display.setData(Tree.ID_GRAYUNCHECKED, null);
                display.setData(Tree.ID_CHECKMARK, null);
                display.setData(Tree.ID_ARROWDOWN, null);
                display.setData(Tree.ID_ARROWUP, null);
            }
        });
    }

    void makeAvailable(TreeItem item) {
        int parentItemCount = item.parentItem.items.length;
        int index = 0;
        if (parentItemCount == 1) {
            index = item.parentItem.availableIndex + 1;
        } else {
            int itemIndex = 0;
            TreeItem[] items = item.parentItem.items;
            int i = 0;
            while (i < items.length) {
                if (items[i] == item) {
                    itemIndex = i;
                    break;
                }
                ++i;
            }
            if (itemIndex != parentItemCount - 1) {
                index = items[itemIndex + 1].availableIndex;
            } else {
                TreeItem previousItem = items[itemIndex - 1];
                index = previousItem.availableIndex + previousItem.computeAvailableDescendentCount();
            }
        }
        if (this.availableItemsCount == this.availableItems.length) {
            int grow = this.drawCount <= 0 ? 4 : Math.max(4, this.availableItems.length * 3 / 2);
            TreeItem[] newAvailableItems = new TreeItem[this.availableItems.length + grow];
            System.arraycopy(this.availableItems, 0, newAvailableItems, 0, this.availableItems.length);
            this.availableItems = newAvailableItems;
        }
        if (index != this.availableItemsCount) {
            System.arraycopy(this.availableItems, index, this.availableItems, index + 1, this.availableItemsCount - index);
        }
        this.availableItems[index] = item;
        ++this.availableItemsCount;
        int i = index;
        while (i < this.availableItemsCount) {
            this.availableItems[i].availableIndex = i;
            ++i;
        }
    }

    void makeDescendentsAvailable(TreeItem item, TreeItem[] descendents) {
        int itemAvailableIndex = item.availableIndex;
        TreeItem[] newAvailableItems = new TreeItem[this.availableItemsCount + descendents.length - 1];
        System.arraycopy(this.availableItems, 0, newAvailableItems, 0, itemAvailableIndex);
        System.arraycopy(descendents, 0, newAvailableItems, itemAvailableIndex, descendents.length);
        int startIndex = itemAvailableIndex + 1;
        System.arraycopy(this.availableItems, startIndex, newAvailableItems, itemAvailableIndex + descendents.length, this.availableItemsCount - startIndex);
        this.availableItems = newAvailableItems;
        this.availableItemsCount = this.availableItems.length;
        int i = itemAvailableIndex;
        while (i < this.availableItemsCount) {
            this.availableItems[i].availableIndex = i;
            ++i;
        }
    }

    void makeDescendentsUnavailable(TreeItem item, TreeItem[] descendents) {
        int descendentsLength = descendents.length;
        TreeItem[] newAvailableItems = new TreeItem[this.availableItemsCount - descendentsLength + 1];
        System.arraycopy(this.availableItems, 0, newAvailableItems, 0, item.availableIndex + 1);
        int startIndex = item.availableIndex + descendentsLength;
        System.arraycopy(this.availableItems, startIndex, newAvailableItems, item.availableIndex + 1, this.availableItemsCount - startIndex);
        this.availableItems = newAvailableItems;
        this.availableItemsCount = this.availableItems.length;
        int i = 1;
        while (i < descendents.length) {
            descendents[i].availableIndex = -1;
            ++i;
        }
        i = item.availableIndex;
        while (i < this.availableItemsCount) {
            this.availableItems[i].availableIndex = i;
            ++i;
        }
        i = this.selectedItems.length - 1;
        while (i >= 0) {
            if (this.selectedItems[i] != item && this.selectedItems[i].hasAncestor(item)) {
                this.removeSelectedItem(i);
            }
            --i;
        }
        if (this.anchorItem != null && this.anchorItem != item && this.anchorItem.hasAncestor(item)) {
            this.anchorItem = null;
        }
    }

    void onArrowDown(int stateMask) {
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.availableIndex + 1;
            if (newFocusIndex == this.availableItemsCount) {
                return;
            }
            this.selectItem(this.availableItems[newFocusIndex], false);
            this.setFocusItem(this.availableItems[newFocusIndex], true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(this.availableItems[newFocusIndex]);
            Event newEvent = new Event();
            newEvent.item = this.availableItems[newFocusIndex];
            this.postEvent(13, newEvent);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.availableItemsCount <= this.topIndex + visibleItemCount) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC(this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gc.dispose();
                return;
            }
            int newFocusIndex = this.focusItem.availableIndex + 1;
            if (newFocusIndex == this.availableItemsCount) {
                return;
            }
            this.selectItem(this.availableItems[newFocusIndex], false);
            this.setFocusItem(this.availableItems[newFocusIndex], true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(this.availableItems[newFocusIndex]);
            Event newEvent = new Event();
            newEvent.item = this.availableItems[newFocusIndex];
            this.postEvent(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.availableItemsCount <= this.topIndex + visibleItemCount) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC(this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gc.dispose();
                return;
            }
            int focusIndex = this.focusItem.availableIndex;
            if (focusIndex == this.availableItemsCount - 1) {
                return;
            }
            TreeItem newFocusItem = this.availableItems[focusIndex + 1];
            this.setFocusItem(newFocusItem, true);
            this.redrawItem(newFocusItem.availableIndex, true);
            this.showItem(newFocusItem);
            return;
        }
        int newFocusIndex = this.focusItem.availableIndex + 1;
        if (newFocusIndex == this.availableItemsCount) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.focusItem.availableIndex < this.anchorItem.availableIndex) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        this.selectItem(this.availableItems[newFocusIndex], true);
        this.setFocusItem(this.availableItems[newFocusIndex], true);
        this.redrawItem(newFocusIndex, true);
        this.showItem(this.availableItems[newFocusIndex]);
        Event newEvent = new Event();
        newEvent.item = this.availableItems[newFocusIndex];
        this.postEvent(13, newEvent);
    }

    void onArrowLeft(int stateMask) {
        if ((stateMask & 0x40000) != 0) {
            if (this.horizontalOffset == 0) {
                return;
            }
            int newSelection = Math.max(0, this.horizontalOffset - 5);
            this.update();
            GC gc = new GC(this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
            if (this.header.getVisible()) {
                this.header.update();
                Rectangle headerClientArea = this.header.getClientArea();
                gc = new GC(this.header);
                gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
                gc.dispose();
            }
            this.horizontalOffset = newSelection;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setSelection(this.horizontalOffset);
            }
            return;
        }
        if (this.focusItem.expanded) {
            this.focusItem.setExpanded(false);
            Event newEvent = new Event();
            newEvent.item = this.focusItem;
            this.sendEvent(18, newEvent);
            return;
        }
        TreeItem parentItem = this.focusItem.parentItem;
        if (parentItem == null) {
            return;
        }
        this.selectItem(parentItem, false);
        this.setFocusItem(parentItem, true);
        this.redrawItem(parentItem.availableIndex, true);
        this.showItem(parentItem);
        Event newEvent = new Event();
        newEvent.item = parentItem;
        this.postEvent(13, newEvent);
    }

    void onArrowRight(int stateMask) {
        if ((stateMask & 0x40000) != 0) {
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                int clientWidth = this.clientArea.width;
                int maximum = hBar.getMaximum();
                if (this.horizontalOffset + clientWidth == maximum) {
                    return;
                }
                if (maximum <= clientWidth) {
                    return;
                }
                int newSelection = Math.min(this.horizontalOffset + 5, maximum - clientWidth);
                this.update();
                GC gc = new GC(this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
                gc.dispose();
                if (this.header.getVisible()) {
                    Rectangle headerClientArea = this.header.getClientArea();
                    this.header.update();
                    gc = new GC(this.header);
                    gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
                    gc.dispose();
                }
                this.horizontalOffset = newSelection;
                hBar.setSelection(this.horizontalOffset);
            }
            return;
        }
        TreeItem[] children = this.focusItem.items;
        if (children.length == 0) {
            return;
        }
        if (!this.focusItem.expanded) {
            this.focusItem.setExpanded(true);
            Event newEvent = new Event();
            newEvent.item = this.focusItem;
            this.inExpand = true;
            this.sendEvent(17, newEvent);
            this.inExpand = false;
            if (this.isDisposed()) {
                return;
            }
            if (this.focusItem.items.length == 0) {
                this.focusItem.expanded = false;
            }
            return;
        }
        this.selectItem(children[0], false);
        this.setFocusItem(children[0], true);
        this.redrawItem(children[0].availableIndex, true);
        this.showItem(children[0]);
        Event newEvent = new Event();
        newEvent.item = children[0];
        this.postEvent(13, newEvent);
    }

    void onArrowUp(int stateMask) {
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.availableIndex - 1;
            if (newFocusIndex < 0) {
                return;
            }
            TreeItem item = this.availableItems[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC(this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gc.dispose();
                return;
            }
            int newFocusIndex = this.focusItem.availableIndex - 1;
            if (newFocusIndex < 0) {
                return;
            }
            TreeItem item = this.availableItems[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(newFocusIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar vBar = this.getVerticalBar();
                if (vBar != null) {
                    vBar.setSelection(this.topIndex);
                }
                GC gc = new GC(this);
                gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gc.dispose();
                return;
            }
            int focusIndex = this.focusItem.availableIndex;
            if (focusIndex == 0) {
                return;
            }
            TreeItem newFocusItem = this.availableItems[focusIndex - 1];
            this.setFocusItem(newFocusItem, true);
            this.showItem(newFocusItem);
            this.redrawItem(newFocusItem.availableIndex, true);
            return;
        }
        int newFocusIndex = this.focusItem.availableIndex - 1;
        if (newFocusIndex < 0) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.anchorItem.availableIndex < this.focusItem.availableIndex) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        TreeItem item = this.availableItems[newFocusIndex];
        this.selectItem(item, true);
        this.setFocusItem(item, true);
        this.redrawItem(newFocusIndex, true);
        this.showItem(item);
        Event newEvent = new Event();
        newEvent.item = item;
        this.postEvent(13, newEvent);
    }

    void onCR() {
        if (this.focusItem == null) {
            return;
        }
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(14, event);
    }

    void onDispose(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.ignoreDispose) {
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int i = 0;
        while (i < this.items.length) {
            this.items[i].dispose(false);
            ++i;
        }
        i = 0;
        while (i < this.columns.length) {
            this.columns[i].dispose(false);
            ++i;
        }
        if (this.toolTipShell != null) {
            this.toolTipShell.dispose();
            this.toolTipShell = null;
            this.toolTipLabel = null;
        }
        this.toolTipListener = null;
        this.horizontalOffset = 0;
        this.availableItemsCount = 0;
        this.topIndex = 0;
        this.selectedItems = null;
        this.items = null;
        this.availableItems = null;
        this.orderedColumns = null;
        this.columns = null;
        this.lastClickedItem = null;
        this.insertMarkItem = null;
        this.anchorItem = null;
        this.focusItem = null;
        this.lastSelectionEvent = null;
        this.header = null;
        this.sortColumn = null;
        this.resizeColumn = null;
        this.expanderBounds = null;
        this.cachedForeground = null;
        this.cachedBackground = null;
    }

    void onEnd(int stateMask) {
        TreeItem selectedItem;
        int lastAvailableIndex = this.availableItemsCount - 1;
        if ((stateMask & 0x60000) == 0) {
            if (this.focusItem.availableIndex == lastAvailableIndex) {
                return;
            }
            TreeItem item = this.availableItems[lastAvailableIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(lastAvailableIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                this.setTopItem(this.availableItems[this.availableItemsCount - visibleItemCount]);
                return;
            }
            if (this.focusItem.availableIndex == lastAvailableIndex) {
                return;
            }
            TreeItem item = this.availableItems[lastAvailableIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(lastAvailableIndex, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                this.showItem(this.availableItems[lastAvailableIndex]);
                return;
            }
            if (this.focusItem.availableIndex == lastAvailableIndex) {
                return;
            }
            TreeItem item = this.availableItems[lastAvailableIndex];
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.availableIndex, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((selectedItem = this.availableItems[lastAvailableIndex]) == this.focusItem && selectedItem.isSelected()) {
            return;
        }
        int anchorIndex = this.anchorItem.availableIndex;
        int selectIndex = selectedItem.availableIndex;
        TreeItem[] newSelection = new TreeItem[selectIndex - anchorIndex + 1];
        int writeIndex = 0;
        int i = anchorIndex;
        while (i <= selectIndex) {
            newSelection[writeIndex++] = this.availableItems[i];
            ++i;
        }
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItems(anchorIndex, selectIndex, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.postEvent(13, newEvent);
    }

    void onFocusIn() {
        this.hasFocus = true;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
            return;
        }
        TreeItem initialFocus = null;
        if (this.selectedItems.length > 0) {
            int i = 0;
            while (i < this.selectedItems.length && initialFocus == null) {
                if (this.selectedItems[i].isAvailable()) {
                    initialFocus = this.selectedItems[i];
                }
                ++i;
            }
            if (initialFocus == null) {
                initialFocus = this.availableItems[this.topIndex];
            }
        } else {
            initialFocus = this.availableItems[this.topIndex];
        }
        this.setFocusItem(initialFocus, false);
        this.redrawItem(initialFocus.availableIndex, true);
    }

    void onFocusOut() {
        this.hasFocus = false;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
        }
    }

    void onHome(int stateMask) {
        TreeItem selectedItem;
        if ((stateMask & 0x60000) == 0) {
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem item = this.availableItems[0];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(0, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x40000) != 0) {
                this.setTopItem(this.availableItems[0]);
                return;
            }
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem item = this.availableItems[0];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.redrawItem(0, true);
            this.showItem(item);
            Event newEvent = new Event();
            newEvent.item = item;
            this.postEvent(13, newEvent);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if ((stateMask & 0x20000) != 0) {
                this.setTopItem(this.availableItems[0]);
                return;
            }
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem item = this.availableItems[0];
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.availableIndex, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((selectedItem = this.availableItems[0]) == this.focusItem && selectedItem.isSelected()) {
            return;
        }
        int anchorIndex = this.anchorItem.availableIndex;
        int selectIndex = selectedItem.availableIndex;
        TreeItem[] newSelection = new TreeItem[anchorIndex + 1];
        int writeIndex = 0;
        int i = anchorIndex;
        while (i >= 0) {
            newSelection[writeIndex++] = this.availableItems[i];
            --i;
        }
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItems(anchorIndex, selectIndex, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.postEvent(13, newEvent);
    }

    void onKeyDown(Event event) {
        String text;
        TreeItem item;
        if (this.ignoreKey) {
            this.ignoreKey = false;
            return;
        }
        this.ignoreKey = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        if (!event.doit) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.onArrowUp(event.stateMask);
                return;
            }
            case 0x1000002: {
                this.onArrowDown(event.stateMask);
                return;
            }
            case 0x1000003: {
                this.onArrowLeft(event.stateMask);
                return;
            }
            case 0x1000004: {
                this.onArrowRight(event.stateMask);
                return;
            }
            case 0x1000005: {
                this.onPageUp(event.stateMask);
                return;
            }
            case 0x1000006: {
                this.onPageDown(event.stateMask);
                return;
            }
            case 0x1000007: {
                this.onHome(event.stateMask);
                return;
            }
            case 0x1000008: {
                this.onEnd(event.stateMask);
                return;
            }
        }
        if (event.character == ' ') {
            this.onSpace();
            return;
        }
        if (event.character == '\r') {
            this.onCR();
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            return;
        }
        int initialIndex = this.focusItem.availableIndex;
        char character = Character.toLowerCase(event.character);
        int i = initialIndex + 1;
        while (i < this.availableItemsCount) {
            item = this.availableItems[i];
            text = item.getText(0, false);
            if (text.length() > 0 && Character.toLowerCase(text.charAt(0)) == character) {
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.redrawItem(i, true);
                this.showItem(item);
                Event newEvent = new Event();
                newEvent.item = item;
                this.postEvent(13, newEvent);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < initialIndex) {
            item = this.availableItems[i];
            text = item.getText(0, false);
            if (text.length() > 0 && Character.toLowerCase(text.charAt(0)) == character) {
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.redrawItem(i, true);
                this.showItem(item);
                Event newEvent = new Event();
                newEvent.item = item;
                this.postEvent(13, newEvent);
                return;
            }
            ++i;
        }
    }

    void onMouseDoubleClick(Event event) {
        int index;
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if ((index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.availableItemsCount) {
            return;
        }
        TreeItem selectedItem = this.availableItems[index];
        if (selectedItem != this.lastClickedItem) {
            return;
        }
        if (selectedItem.items.length > 0 && selectedItem.getExpanderBounds().contains(event.x, event.y)) {
            return;
        }
        if (!selectedItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.postEvent(14, newEvent);
    }

    void onMouseDown(Event event) {
        int index;
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if ((index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || index >= this.availableItemsCount) {
            return;
        }
        TreeItem selectedItem = this.availableItems[index];
        if (selectedItem.items.length > 0 && selectedItem.getExpanderBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            boolean expand = !selectedItem.expanded;
            selectedItem.setExpanded(expand);
            Event newEvent = new Event();
            newEvent.item = selectedItem;
            if (expand) {
                this.inExpand = true;
                this.sendEvent(17, newEvent);
                this.inExpand = false;
                if (this.isDisposed()) {
                    return;
                }
                if (selectedItem.items.length == 0) {
                    selectedItem.expanded = false;
                }
            } else {
                this.sendEvent(18, newEvent);
            }
            return;
        }
        if ((this.style & 0x20) != 0 && selectedItem.getCheckboxBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            selectedItem.setChecked(!selectedItem.checked);
            Event newEvent = new Event();
            newEvent.item = selectedItem;
            newEvent.detail = 32;
            this.postEvent(13, newEvent);
            return;
        }
        if (!selectedItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        boolean sendSelection = true;
        if (this.lastSelectionEvent != null && this.lastSelectionEvent.item == selectedItem) {
            if (event.time - this.lastSelectionEvent.time <= this.display.getDoubleClickTime()) {
                sendSelection = false;
            } else {
                this.lastSelectionEvent = event;
                event.item = selectedItem;
            }
        } else {
            this.lastSelectionEvent = event;
            event.item = selectedItem;
        }
        if ((this.style & 4) != 0) {
            if (!selectedItem.isSelected()) {
                if (event.button == 1) {
                    this.selectItem(selectedItem, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItem(selectedItem.availableIndex, true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.postEvent(13, newEvent);
                    }
                    return;
                }
                if ((event.stateMask & 0x60000) == 0) {
                    this.selectItem(selectedItem, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItem(selectedItem.availableIndex, true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.postEvent(13, newEvent);
                    }
                    return;
                }
            }
            if (event.button == 1) {
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.postEvent(13, newEvent);
                }
                return;
            }
        }
        if (!selectedItem.isSelected()) {
            if (event.button == 1) {
                if ((event.stateMask & 0x60000) == 131072) {
                    if (this.anchorItem == null) {
                        this.anchorItem = this.focusItem;
                    }
                    int anchorIndex = this.anchorItem.availableIndex;
                    int selectIndex = selectedItem.availableIndex;
                    TreeItem[] newSelection = new TreeItem[Math.abs(anchorIndex - selectIndex) + 1];
                    int step = anchorIndex < selectIndex ? 1 : -1;
                    int writeIndex = 0;
                    int i = anchorIndex;
                    while (i != selectIndex) {
                        newSelection[writeIndex++] = this.availableItems[i];
                        i += step;
                    }
                    newSelection[writeIndex] = this.availableItems[selectIndex];
                    this.setSelection(newSelection, false);
                    this.setFocusItem(selectedItem, true);
                    this.redrawItems(Math.min(anchorIndex, selectIndex), Math.max(anchorIndex, selectIndex), true);
                    if (sendSelection) {
                        Event newEvent = new Event();
                        newEvent.item = selectedItem;
                        this.postEvent(13, newEvent);
                    }
                    return;
                }
                this.selectItem(selectedItem, (event.stateMask & 0x40000) != 0);
                this.setFocusItem(selectedItem, true);
                this.redrawItem(selectedItem.availableIndex, true);
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.postEvent(13, newEvent);
                }
                return;
            }
            if ((event.stateMask & 0x60000) == 0) {
                this.selectItem(selectedItem, false);
                this.setFocusItem(selectedItem, true);
                this.redrawItem(selectedItem.availableIndex, true);
                if (sendSelection) {
                    Event newEvent = new Event();
                    newEvent.item = selectedItem;
                    this.postEvent(13, newEvent);
                }
                return;
            }
        }
        if (event.button != 1) {
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            this.removeSelectedItem(this.getSelectionIndex(selectedItem));
            this.setFocusItem(selectedItem, true);
            this.redrawItem(selectedItem.availableIndex, true);
            if (sendSelection) {
                Event newEvent = new Event();
                newEvent.item = selectedItem;
                this.postEvent(13, newEvent);
            }
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            if (this.anchorItem == null) {
                this.anchorItem = this.focusItem;
            }
            int anchorIndex = this.anchorItem.availableIndex;
            int selectIndex = selectedItem.availableIndex;
            TreeItem[] newSelection = new TreeItem[Math.abs(anchorIndex - selectIndex) + 1];
            int step = anchorIndex < selectIndex ? 1 : -1;
            int writeIndex = 0;
            int i = anchorIndex;
            while (i != selectIndex) {
                newSelection[writeIndex++] = this.availableItems[i];
                i += step;
            }
            newSelection[writeIndex] = this.availableItems[selectIndex];
            this.setSelection(newSelection, false);
            this.setFocusItem(selectedItem, true);
            this.redrawItems(Math.min(anchorIndex, selectIndex), Math.max(anchorIndex, selectIndex), true);
            if (sendSelection) {
                Event newEvent = new Event();
                newEvent.item = selectedItem;
                this.postEvent(13, newEvent);
            }
            return;
        }
        this.selectItem(selectedItem, false);
        this.setFocusItem(selectedItem, true);
        this.redrawItem(selectedItem.availableIndex, true);
        if (sendSelection) {
            Event newEvent = new Event();
            newEvent.item = selectedItem;
            this.postEvent(13, newEvent);
        }
    }

    void onMouseUp(Event event) {
        int index = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex;
        if (index < 0 || index >= this.availableItemsCount) {
            return;
        }
        this.lastClickedItem = this.availableItems[index];
    }

    void onPageDown(int stateMask) {
        int selectIndex;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = this.focusItem.availableIndex + visibleItemCount - 1;
            if ((newFocusIndex = Math.min(newFocusIndex, this.availableItemsCount - 1)) == this.focusItem.availableIndex) {
                return;
            }
            TreeItem item = this.availableItems[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.availableIndex, true);
            return;
        }
        if ((stateMask & 0x60000) == 393216) {
            int newTopIndex = this.topIndex + visibleItemCount;
            if ((newTopIndex = Math.min(newTopIndex, this.availableItemsCount - visibleItemCount)) == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[newTopIndex]);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int newFocusIndex = this.focusItem.availableIndex + visibleItemCount - 1;
                if ((newFocusIndex = Math.min(newFocusIndex, this.availableItemsCount - 1)) == this.focusItem.availableIndex) {
                    return;
                }
                TreeItem item = this.availableItems[newFocusIndex];
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.showItem(item);
                this.redrawItem(item.availableIndex, true);
                return;
            }
            int newTopIndex = this.topIndex + visibleItemCount;
            if ((newTopIndex = Math.min(newTopIndex, this.availableItemsCount - visibleItemCount)) == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[newTopIndex]);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            int bottomIndex = Math.min(this.topIndex + visibleItemCount - 1, this.availableItemsCount - 1);
            if (this.focusItem.availableIndex != bottomIndex) {
                this.setFocusItem(this.availableItems[bottomIndex], true);
                this.redrawItem(bottomIndex, true);
            } else {
                int newFocusIndex = Math.min(this.availableItemsCount - 1, bottomIndex + visibleItemCount);
                if (newFocusIndex == this.focusItem.availableIndex) {
                    return;
                }
                this.setFocusItem(this.availableItems[newFocusIndex], true);
                this.showItem(this.availableItems[newFocusIndex]);
                this.redrawItem(newFocusIndex, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int anchorIndex = this.anchorItem.availableIndex;
        int bottomIndex = Math.min(this.topIndex + visibleItemCount - 1, this.availableItemsCount - 1);
        if (this.focusItem.availableIndex != bottomIndex) {
            selectIndex = bottomIndex;
        } else {
            selectIndex = Math.min(this.availableItemsCount - 1, bottomIndex + visibleItemCount);
            if (selectIndex == this.focusItem.availableIndex && this.focusItem.isSelected()) {
                return;
            }
        }
        TreeItem selectedItem = this.availableItems[selectIndex];
        TreeItem[] newSelection = new TreeItem[Math.abs(anchorIndex - selectIndex) + 1];
        int step = anchorIndex < selectIndex ? 1 : -1;
        int writeIndex = 0;
        int i = anchorIndex;
        while (i != selectIndex) {
            newSelection[writeIndex++] = this.availableItems[i];
            i += step;
        }
        newSelection[writeIndex] = this.availableItems[selectIndex];
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.postEvent(13, newEvent);
    }

    void onPageUp(int stateMask) {
        int selectIndex;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((stateMask & 0x60000) == 0) {
            int newFocusIndex = Math.max(0, this.focusItem.availableIndex - visibleItemCount + 1);
            if (newFocusIndex == this.focusItem.availableIndex) {
                return;
            }
            TreeItem item = this.availableItems[newFocusIndex];
            this.selectItem(item, false);
            this.setFocusItem(item, true);
            this.showItem(item);
            this.redrawItem(item.availableIndex, true);
            return;
        }
        if ((stateMask & 0x60000) == 393216) {
            int newTopIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (newTopIndex == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[newTopIndex]);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((stateMask & 0x20000) != 0) {
                int newFocusIndex = Math.max(0, this.focusItem.availableIndex - visibleItemCount + 1);
                if (newFocusIndex == this.focusItem.availableIndex) {
                    return;
                }
                TreeItem item = this.availableItems[newFocusIndex];
                this.selectItem(item, false);
                this.setFocusItem(item, true);
                this.showItem(item);
                this.redrawItem(item.availableIndex, true);
                return;
            }
            int newTopIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (newTopIndex == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[newTopIndex]);
            return;
        }
        if ((stateMask & 0x40000) != 0) {
            if (this.focusItem.availableIndex != this.topIndex) {
                this.setFocusItem(this.availableItems[this.topIndex], true);
                this.redrawItem(this.topIndex, true);
            } else {
                int newFocusIndex = Math.max(0, this.focusItem.availableIndex - visibleItemCount);
                if (newFocusIndex == this.focusItem.availableIndex) {
                    return;
                }
                this.setFocusItem(this.availableItems[newFocusIndex], true);
                this.showItem(this.availableItems[newFocusIndex]);
                this.redrawItem(newFocusIndex, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int anchorIndex = this.anchorItem.availableIndex;
        if (this.focusItem.availableIndex != this.topIndex) {
            selectIndex = this.topIndex;
        } else {
            selectIndex = Math.max(0, this.topIndex - visibleItemCount);
            if (selectIndex == this.focusItem.availableIndex && this.focusItem.isSelected()) {
                return;
            }
        }
        TreeItem selectedItem = this.availableItems[selectIndex];
        TreeItem[] newSelection = new TreeItem[Math.abs(anchorIndex - selectIndex) + 1];
        int step = anchorIndex < selectIndex ? 1 : -1;
        int writeIndex = 0;
        int i = anchorIndex;
        while (i != selectIndex) {
            newSelection[writeIndex++] = this.availableItems[i];
            i += step;
        }
        newSelection[writeIndex] = this.availableItems[selectIndex];
        this.setSelection(newSelection, false);
        this.setFocusItem(selectedItem, true);
        this.showItem(selectedItem);
        Event newEvent = new Event();
        newEvent.item = selectedItem;
        this.postEvent(13, newEvent);
    }

    void onPaint(Event event) {
        TreeColumn column;
        int rightX;
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        GC gc = event.gc;
        Rectangle clipping = gc.getClipping();
        int headerHeight = this.getHeaderHeight();
        int numColumns = orderedColumns.length;
        int startColumn = -1;
        int endColumn = -1;
        if (numColumns > 0) {
            startColumn = this.computeColumnIntersect(clipping.x, 0);
            if (startColumn != -1 && (endColumn = this.computeColumnIntersect(clipping.x + clipping.width, startColumn)) == -1) {
                endColumn = numColumns - 1;
            }
        } else {
            endColumn = 0;
            startColumn = 0;
        }
        int startIndex = (clipping.y - headerHeight) / this.itemHeight + this.topIndex;
        int endIndex = -1;
        if (startIndex < this.availableItemsCount) {
            endIndex = startIndex + Compatibility.ceil(clipping.height, this.itemHeight);
        }
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(endIndex, this.availableItemsCount - 1);
        this.cachedBackground = this.getBackground();
        gc.setBackground(this.cachedBackground);
        gc.setClipping(clipping);
        int bottomY = endIndex >= 0 ? this.getItemY(this.availableItems[endIndex]) + this.itemHeight : 0;
        int fillHeight = Math.max(0, this.clientArea.height - bottomY);
        if (fillHeight > 0) {
            this.drawBackground(gc, 0, bottomY, this.clientArea.width, fillHeight, 0, 0);
        }
        if (this.columns.length > 0 && (rightX = (column = orderedColumns[orderedColumns.length - 1]).getX() + column.width) < this.clientArea.width) {
            this.drawBackground(gc, rightX, 0, this.clientArea.width - rightX, this.clientArea.height - fillHeight, 0, 0);
        }
        boolean noFocusDraw = false;
        int[] lineDash = gc.getLineDash();
        int lineWidth = gc.getLineWidth();
        this.cachedForeground = this.getForeground();
        int i = startIndex;
        while (i <= Math.min(endIndex, this.availableItemsCount - 1)) {
            TreeItem item = this.availableItems[i];
            if (!item.isDisposed()) {
                if (startColumn == -1) {
                    noFocusDraw = item.paint(gc, null, true) || noFocusDraw;
                } else if (numColumns == 0) {
                    noFocusDraw = item.paint(gc, null, false) || noFocusDraw;
                } else {
                    int j = startColumn;
                    while (j <= Math.min(endColumn, this.columns.length - 1)) {
                        if (!item.isDisposed()) {
                            boolean bl = noFocusDraw = item.paint(gc, orderedColumns[j], false) || noFocusDraw;
                        }
                        if (this.isDisposed() || gc.isDisposed()) {
                            this.cachedForeground = null;
                            this.cachedBackground = null;
                            return;
                        }
                        ++j;
                    }
                }
            }
            if (this.isDisposed() || gc.isDisposed()) {
                this.cachedForeground = null;
                this.cachedBackground = null;
                return;
            }
            ++i;
        }
        this.cachedForeground = null;
        this.cachedBackground = null;
        gc.setClipping(clipping);
        gc.setLineWidth(lineWidth);
        if (this.linesVisible) {
            gc.setForeground(this.display.getSystemColor(19));
            gc.setLineDash(lineDash);
            if (numColumns > 0 && startColumn != -1) {
                i = startColumn;
                while (i <= endColumn) {
                    int x = orderedColumns[i].getX() + orderedColumns[i].width - 1;
                    gc.drawLine(x, clipping.y, x, clipping.y + clipping.height);
                    ++i;
                }
            }
            bottomY = clipping.y + clipping.height;
            int rightX2 = clipping.x + clipping.width;
            int y = (clipping.y - headerHeight) / this.itemHeight * this.itemHeight + headerHeight;
            while (y <= bottomY) {
                gc.drawLine(clipping.x, y, rightX2, y);
                y += this.itemHeight;
            }
        }
        if (!noFocusDraw && this.isFocusControl()) {
            if (this.focusItem != null) {
                Rectangle focusBounds = this.focusItem.getFocusBounds();
                if (focusBounds.width > 0) {
                    gc.setForeground(this.display.getSystemColor(2));
                    gc.setClipping(focusBounds);
                    if (this.focusItem.isSelected()) {
                        gc.setLineDash(new int[]{2, 2});
                    } else {
                        gc.setLineDash(new int[]{1, 1});
                    }
                    gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width, focusBounds.height);
                }
            } else {
                int y = headerHeight + 1;
                int width = Math.max(0, this.clientArea.width - 2);
                int height = Math.max(0, this.clientArea.height - headerHeight - 2);
                gc.setForeground(this.display.getSystemColor(2));
                gc.setClipping(1, y, width, height);
                gc.setLineDash(new int[]{1, 1});
                gc.drawFocus(1, y, width, height);
            }
        }
        if (this.insertMarkItem != null) {
            Rectangle focusBounds = this.insertMarkItem.getFocusBounds();
            gc.setForeground(this.display.getSystemColor(2));
            gc.setClipping(focusBounds);
            gc.setLineDash(lineDash);
            if (this.insertMarkPrecedes) {
                gc.drawLine(focusBounds.x, focusBounds.y, focusBounds.x + focusBounds.width, focusBounds.y);
            } else {
                int y = focusBounds.y + focusBounds.height - 1;
                gc.drawLine(focusBounds.x, y, focusBounds.x + focusBounds.width, y);
            }
        }
    }

    void onResize(Event event) {
        ScrollBar hBar;
        boolean visible;
        this.clientArea = this.getClientArea();
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            int clientHeight = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            int thumb = Math.min(clientHeight, this.availableItemsCount);
            vBar.setThumb(thumb);
            vBar.setPageIncrement(thumb);
            int index = vBar.getSelection();
            if (index != this.topIndex) {
                this.topIndex = index;
                this.redraw();
            }
            boolean bl = visible = clientHeight < this.availableItemsCount;
            if (visible != vBar.getVisible()) {
                vBar.setVisible(visible);
                this.clientArea = this.getClientArea();
            }
        }
        if ((hBar = this.getHorizontalBar()) != null) {
            int hBarMaximum = hBar.getMaximum();
            int thumb = Math.min(this.clientArea.width, hBarMaximum);
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
            this.horizontalOffset = hBar.getSelection();
            boolean bl = visible = this.clientArea.width < hBarMaximum;
            if (visible != hBar.getVisible()) {
                hBar.setVisible(visible);
                this.clientArea = this.getClientArea();
            }
        }
        int headerHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        this.header.setSize(this.clientArea.width, headerHeight);
        if (this.availableItemsCount == 0 && this.isFocusControl()) {
            this.redraw();
        }
    }

    void onScrollHorizontal(Event event) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int newSelection = hBar.getSelection();
        this.update();
        if (this.availableItemsCount > 0) {
            GC gc = new GC(this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        } else {
            this.redraw();
        }
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.update();
            Rectangle headerClientArea = this.header.getClientArea();
            GC gc = new GC(this.header);
            gc.copyArea(0, 0, headerClientArea.width, headerClientArea.height, this.horizontalOffset - newSelection, 0);
            gc.dispose();
        }
        this.horizontalOffset = newSelection;
    }

    void onScrollVertical(Event event) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            int newSelection = vBar.getSelection();
            this.update();
            GC gc = new GC(this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, (this.topIndex - newSelection) * this.itemHeight);
            gc.dispose();
            this.topIndex = newSelection;
        }
    }

    void onSpace() {
        if (this.focusItem == null) {
            return;
        }
        if (!this.focusItem.isSelected()) {
            this.selectItem(this.focusItem, (this.style & 2) != 0);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        if ((this.style & 0x20) != 0) {
            this.focusItem.setChecked(!this.focusItem.checked);
        }
        this.showItem(this.focusItem);
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(13, event);
        if ((this.style & 0x20) == 0) {
            return;
        }
        event = new Event();
        event.item = this.focusItem;
        event.detail = 32;
        this.postEvent(13, event);
    }

    void reassignFocus() {
        if (this.focusItem == null) {
            return;
        }
        if (this.focusItem.parentItem != null) {
            TreeItem item = this.focusItem.parentItem;
            this.setFocusItem(item, false);
            this.showItem(item);
            return;
        }
        int index = this.focusItem.getIndex();
        index = index != 0 ? --index : ++index;
        if (index < this.items.length) {
            TreeItem item = this.items[index];
            this.setFocusItem(item, false);
            this.showItem(item);
        } else {
            this.setFocusItem(null, false);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw(x, y, width, height, all);
        }
    }

    void redrawFromItemDownwards(int index) {
        this.redrawItems(index, this.availableItemsCount - 1, false);
    }

    void redrawItem(int itemIndex, boolean focusBoundsOnly) {
        if (itemIndex == -1) {
            return;
        }
        if (itemIndex < this.availableItemsCount && !this.availableItems[itemIndex].isInViewport()) {
            return;
        }
        this.redrawItems(itemIndex, itemIndex, focusBoundsOnly);
    }

    void redrawItems(int startIndex, int endIndex, boolean focusBoundsOnly) {
        if (this.drawCount > 0) {
            return;
        }
        int startY = (startIndex - this.topIndex) * this.itemHeight + this.getHeaderHeight();
        int height = (endIndex - startIndex + 1) * this.itemHeight;
        if (focusBoundsOnly) {
            boolean custom;
            boolean bl = custom = this.hooks(40) || this.hooks(42);
            if (!custom && this.columns.length > 0) {
                TreeColumn lastColumn;
                if ((this.style & 0x10000) != 0) {
                    TreeColumn[] orderedColumns = this.getOrderedColumns();
                    lastColumn = orderedColumns[orderedColumns.length - 1];
                } else {
                    lastColumn = this.columns[0];
                }
                int rightX = lastColumn.getX() + lastColumn.getWidth();
                if (rightX <= 0) {
                    return;
                }
            }
            endIndex = Math.min(endIndex, this.availableItemsCount - 1);
            int i = startIndex;
            while (i <= endIndex) {
                TreeItem item = this.availableItems[i];
                if (item.isInViewport()) {
                    if (custom) {
                        this.redraw(0, this.getItemY(item), this.clientArea.width, this.itemHeight, false);
                    } else {
                        Rectangle bounds = item.getFocusBounds();
                        this.redraw(bounds.x, startY, bounds.width, height, false);
                    }
                }
                ++i;
            }
        } else {
            this.redraw(0, startY, this.clientArea.width, height, false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        this.setRedraw(false);
        this.setFocusItem(null, false);
        int i = 0;
        while (i < this.items.length) {
            this.items[i].dispose(false);
            ++i;
        }
        this.selectedItems = NO_ITEMS;
        this.availableItems = NO_ITEMS;
        this.items = this.availableItems;
        this.topIndex = 0;
        this.availableItemsCount = 0;
        this.insertMarkItem = null;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.lastSelectionEvent = null;
        this.inExpand = false;
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setMaximum(1);
            vBar.setVisible(false);
        }
        if (this.columns.length == 0) {
            this.horizontalOffset = 0;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setMaximum(1);
                hBar.setVisible(false);
            }
        }
        this.setRedraw(true);
    }

    String removeMnemonics(String string) {
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            if (chars[i] == '&') {
                if (++i == chars.length) break;
                if (chars[i] == '&') {
                    chars[j++] = chars[i - 1];
                }
            }
            chars[j] = chars[i];
            ++i;
            ++j;
        }
        if (i == j) {
            return string;
        }
        return new String(chars, 0, j);
    }

    void removeSelectedItem(int index) {
        TreeItem[] newSelectedItems = new TreeItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, newSelectedItems, 0, index);
        System.arraycopy(this.selectedItems, index + 1, newSelectedItems, index, newSelectedItems.length - index);
        this.selectedItems = newSelectedItems;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Tree.error(4);
        }
        this.removeListener(17, listener);
        this.removeListener(18, listener);
    }

    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                if (column != null) {
                    column.reskinChildren(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        this.selectItem(item, (this.style & 2) != 0);
        this.redrawItem(item.availableIndex, true);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.selectedItems = new TreeItem[this.availableItemsCount];
        System.arraycopy(this.availableItems, 0, this.selectedItems, 0, this.availableItemsCount);
        this.redraw();
    }

    void selectItem(TreeItem item, boolean addToSelection) {
        TreeItem[] oldSelectedItems = this.selectedItems;
        if (!addToSelection || (this.style & 4) != 0) {
            this.selectedItems = new TreeItem[]{item};
            int i = 0;
            while (i < oldSelectedItems.length) {
                if (oldSelectedItems[i] != item) {
                    this.redrawItem(oldSelectedItems[i].availableIndex, true);
                }
                ++i;
            }
        } else {
            if (item.isSelected()) {
                return;
            }
            this.selectedItems = new TreeItem[this.selectedItems.length + 1];
            System.arraycopy(oldSelectedItems, 0, this.selectedItems, 0, oldSelectedItems.length);
            this.selectedItems[this.selectedItems.length - 1] = item;
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(25);
        }
        super.setBackground(color);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        this.cachedBackground = null;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            Tree.error(4);
        }
        if (this.columns.length == 0) {
            if (order.length != 0) {
                Tree.error(5);
            }
            return;
        }
        if (order.length != this.columns.length) {
            Tree.error(5);
        }
        boolean reorder = false;
        boolean[] seen = new boolean[this.columns.length];
        int[] oldOrder = this.getColumnOrder();
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columns.length) {
                Tree.error(6);
            }
            if (seen[index]) {
                Tree.error(5);
            }
            seen[index] = true;
            if (index != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (!reorder) {
            return;
        }
        this.headerHideToolTip();
        int[] oldX = new int[this.columns.length];
        int i2 = 0;
        while (i2 < this.columns.length) {
            oldX[i2] = this.columns[i2].getX();
            ++i2;
        }
        this.orderedColumns = new TreeColumn[order.length];
        i2 = 0;
        while (i2 < order.length) {
            this.orderedColumns[i2] = this.columns[order[i2]];
            ++i2;
        }
        if (oldOrder[0] != order[0]) {
            this.orderedCol0imageWidth = this.columns[order[0]].itemImageWidth;
            GC gc = new GC(this);
            int i3 = 0;
            while (i3 < this.items.length) {
                this.items[i3].updateColumnWidth(this.columns[oldOrder[0]], gc);
                this.items[i3].updateColumnWidth(this.columns[order[0]], gc);
                ++i3;
            }
            gc.dispose();
        }
        i = 0;
        while (i < this.orderedColumns.length) {
            TreeColumn column = this.orderedColumns[i];
            if (!column.isDisposed() && column.getX() != oldX[column.getIndex()]) {
                column.sendEvent(10);
            }
            ++i;
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    void setFocusItem(TreeItem item, boolean redrawOldFocus) {
        if (item == this.focusItem) {
            return;
        }
        TreeItem oldFocusItem = this.focusItem;
        this.focusItem = item;
        if (redrawOldFocus && oldFocusItem != null) {
            this.redrawItem(oldFocusItem.availableIndex, true);
        }
    }

    public void setFont(Font value) {
        ScrollBar vBar;
        this.checkWidget();
        Font oldFont = this.getFont();
        super.setFont(value);
        Font font = this.getFont();
        if (font.equals(oldFont)) {
            return;
        }
        GC gc = new GC(this);
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
        Point headerSize = this.header.getSize();
        int newHeaderHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (headerSize.y != newHeaderHeight) {
            this.header.setSize(headerSize.x, newHeaderHeight);
        }
        this.header.setFont(font);
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].updateFont(gc);
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            this.items[i].updateFont(gc);
            ++i;
        }
        gc.dispose();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
        if (this.columns.length == 0) {
            this.updateHorizontalBar();
        }
        if ((vBar = this.getVerticalBar()) != null) {
            int thumb = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            if (vBar.getThumb() != thumb) {
                vBar.setThumb(thumb);
                vBar.setPageIncrement(thumb);
            }
            this.topIndex = vBar.getSelection();
            vBar.setVisible(thumb < vBar.getMaximum());
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(24);
        }
        super.setForeground(color);
    }

    void setForegroundPixel(int pixel) {
        super.setForegroundPixel(pixel);
        this.cachedForeground = null;
    }

    void setHeaderImageHeight(int value) {
        this.headerImageHeight = value;
        Point headerSize = this.header.getSize();
        int newHeaderHeight = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (headerSize.y != newHeaderHeight) {
            this.header.setSize(headerSize.x, newHeaderHeight);
        }
    }

    public void setHeaderVisible(boolean value) {
        this.checkWidget();
        if (this.header.getVisible() == value) {
            return;
        }
        this.headerHideToolTip();
        this.header.setVisible(value);
        this.updateVerticalBar();
        this.redraw();
    }

    void setImageHeight(int value) {
        this.imageHeight = value;
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            Tree.error(5);
        }
        if (item != null && item.parent != this) {
            return;
        }
        if (item == this.insertMarkItem && before == this.insertMarkPrecedes) {
            return;
        }
        TreeItem oldInsertItem = this.insertMarkItem;
        this.insertMarkItem = item;
        this.insertMarkPrecedes = before;
        if (oldInsertItem != null && oldInsertItem.availableIndex != -1) {
            this.redrawItem(oldInsertItem.availableIndex, true);
        }
        if (item != null && item != oldInsertItem && item.availableIndex != -1) {
            this.redrawItem(item.availableIndex, true);
        }
    }

    public void setItemCount(int count) {
        int redrawEnd;
        int redrawStart;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.items.length) {
            return;
        }
        int oldCount = this.availableItemsCount;
        if (count < this.items.length) {
            redrawStart = count > 0 ? this.items[count - 1].availableIndex : 0;
            redrawEnd = this.availableItemsCount - 1;
            this.availableItemsCount = this.items[count].availableIndex;
            int i = count;
            while (i < this.items.length) {
                this.items[i].dispose(false);
                ++i;
            }
            if (count == 0) {
                this.items = NO_ITEMS;
            } else {
                TreeItem[] newItems = new TreeItem[count];
                System.arraycopy(this.items, 0, newItems, 0, count);
                this.items = newItems;
            }
            int newSelectedCount = 0;
            int i2 = 0;
            while (i2 < this.selectedItems.length) {
                if (!this.selectedItems[i2].isDisposed()) {
                    ++newSelectedCount;
                }
                ++i2;
            }
            if (newSelectedCount != this.selectedItems.length) {
                TreeItem[] newSelectedItems = new TreeItem[newSelectedCount];
                int pos = 0;
                int i3 = 0;
                while (i3 < this.selectedItems.length) {
                    TreeItem item = this.selectedItems[i3];
                    if (!item.isDisposed()) {
                        newSelectedItems[pos++] = item;
                    }
                    ++i3;
                }
                this.selectedItems = newSelectedItems;
            }
            if (this.insertMarkItem != null && this.insertMarkItem.isDisposed()) {
                this.insertMarkItem = null;
            }
            if (this.lastClickedItem != null && this.lastClickedItem.isDisposed()) {
                this.lastClickedItem = null;
            }
            if (this.anchorItem != null && this.anchorItem.isDisposed()) {
                this.anchorItem = null;
            }
            if (this.focusItem != null && this.focusItem.isDisposed()) {
                TreeItem newFocusItem = count > 0 ? this.items[count - 1] : null;
                this.setFocusItem(newFocusItem, false);
            }
            if (this.columns.length == 0) {
                this.updateHorizontalBar();
            }
        } else {
            int grow = count - this.items.length;
            redrawStart = this.items.length == 0 ? 0 : this.items[this.items.length - 1].availableIndex;
            redrawEnd = this.availableItemsCount + grow - 1;
            TreeItem[] newItems = new TreeItem[count];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            if (this.availableItems.length < this.availableItemsCount + grow) {
                TreeItem[] newAvailableItems = new TreeItem[this.availableItemsCount + grow];
                System.arraycopy(this.availableItems, 0, newAvailableItems, 0, this.availableItemsCount);
                this.availableItems = newAvailableItems;
            }
            int i = this.items.length - grow;
            while (i < count) {
                TreeItem newItem;
                this.items[i] = newItem = new TreeItem(this, 0, i, false);
                this.items[i].availableIndex = this.availableItemsCount;
                this.availableItems[this.availableItemsCount++] = newItem;
                ++i;
            }
            if (oldCount == 0) {
                this.focusItem = this.availableItems[0];
            }
        }
        this.updateVerticalBar();
        if ((oldCount == 0 || this.availableItemsCount == 0) && this.isFocusControl()) {
            this.redraw();
            return;
        }
        this.redrawItems(redrawStart, redrawEnd, false);
    }

    boolean setItemHeight(int value) {
        boolean update;
        boolean bl = update = !this.customHeightSet || this.itemHeight < value;
        if (update) {
            this.itemHeight = value;
        }
        return update;
    }

    public void setLinesVisible(boolean value) {
        this.checkWidget();
        if (this.linesVisible == value) {
            return;
        }
        this.linesVisible = value;
        this.redraw();
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.header.setMenu(menu);
    }

    public void setRedraw(boolean value) {
        this.checkWidget();
        if (value) {
            if (--this.drawCount == 0) {
                if (this.availableItems.length - this.availableItemsCount > 3) {
                    TreeItem[] newAvailableItems = new TreeItem[this.availableItemsCount];
                    System.arraycopy(this.availableItems, 0, newAvailableItems, 0, this.availableItemsCount);
                    this.availableItems = newAvailableItems;
                }
                this.updateVerticalBar();
                this.updateHorizontalBar();
            }
        } else {
            ++this.drawCount;
        }
        super.setRedraw(value);
        this.header.setRedraw(value);
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        this.setSelection(new TreeItem[]{item}, true);
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            Tree.error(4);
        }
        this.setSelection(items, true);
    }

    void setSelection(TreeItem[] items, boolean updateViewport) {
        if (items.length == 0 || (this.style & 4) != 0 && items.length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem[] oldSelection = this.selectedItems;
        int index = 0;
        this.selectedItems = new TreeItem[items.length];
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item != null && item.parent == this && !item.isSelected()) {
                this.selectedItems[index++] = item;
            }
            ++i;
        }
        if (index != items.length) {
            TreeItem[] temp = new TreeItem[index];
            System.arraycopy(this.selectedItems, 0, temp, 0, index);
            this.selectedItems = temp;
        }
        if (this.selectedItems.length == 0) {
            this.deselectAll();
            return;
        }
        i = 0;
        while (i < oldSelection.length) {
            int availableIndex;
            if (!oldSelection[i].isSelected() && (availableIndex = oldSelection[i].availableIndex) != -1) {
                this.redrawItem(availableIndex, true);
            }
            ++i;
        }
        if (updateViewport) {
            this.showItem(this.selectedItems[0]);
            this.setFocusItem(this.selectedItems[0], true);
        }
        i = 0;
        while (i < this.selectedItems.length) {
            int availableIndex = this.selectedItems[i].availableIndex;
            if (availableIndex != -1) {
                this.redrawItem(availableIndex, true);
            }
            ++i;
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            Tree.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public void setTopItem(TreeItem item) {
        int visibleItemCount;
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        if (item.parent != this) {
            return;
        }
        if (!item.isAvailable()) {
            item.parentItem.expandAncestors();
        }
        if (this.availableItemsCount < (visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight)) {
            return;
        }
        int index = Math.min(item.availableIndex, this.availableItemsCount - visibleItemCount);
        if (this.topIndex == index) {
            return;
        }
        this.update();
        int change = this.topIndex - index;
        this.topIndex = index;
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setSelection(this.topIndex);
        }
        if (this.drawCount <= 0) {
            GC gc = new GC(this);
            gc.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, change * this.itemHeight);
            gc.dispose();
        }
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            Tree.error(4);
        }
        if (column.isDisposed()) {
            Tree.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int x = column.getX();
        int rightX = x + column.width;
        if (x >= 0 && rightX <= this.clientArea.width) {
            return;
        }
        this.headerHideToolTip();
        int absX = 0;
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int i = 0;
        while (i < column.getOrderIndex()) {
            absX += orderedColumns[i].width;
            ++i;
        }
        this.horizontalOffset = x < this.clientArea.x ? absX : absX + column.width - this.clientArea.width;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setSelection(this.horizontalOffset);
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            Tree.error(4);
        }
        if (item.isDisposed()) {
            Tree.error(5);
        }
        if (item.parent != this) {
            return;
        }
        if (!item.isAvailable()) {
            item.parentItem.expandAncestors();
        }
        int index = item.availableIndex;
        int visibleItemCount = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.topIndex <= index && index < this.topIndex + visibleItemCount) {
            return;
        }
        if (index <= this.topIndex) {
            this.setTopItem(item);
        } else {
            visibleItemCount = Math.max(visibleItemCount, 1);
            this.setTopItem(this.availableItems[Math.min(index - visibleItemCount + 1, this.availableItemsCount - 1)]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return;
        }
        this.showItem(this.selectedItems[0]);
    }

    void updateColumnWidth(TreeColumn column, int width) {
        int change;
        this.headerHideToolTip();
        int oldWidth = column.width;
        int columnX = column.getX();
        int x = columnX + oldWidth - 1;
        this.update();
        GC gc = new GC(this);
        gc.copyArea(x, 0, this.clientArea.width - x, this.clientArea.height, columnX + width - 1, 0);
        if (width > oldWidth) {
            change = width - oldWidth + 1;
            this.redraw(x - 1, 0, change + 1, this.clientArea.height, false);
        } else {
            change = oldWidth - width + 1;
            this.redraw(this.clientArea.width - change, 0, change, this.clientArea.height, false);
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        GC headerGC = new GC(this.header);
        if (this.drawCount <= 0 && this.header.getVisible()) {
            int change2;
            Rectangle headerBounds = this.header.getClientArea();
            this.header.update();
            headerGC.copyArea(--x, 0, headerBounds.width - x, headerBounds.height, columnX + width - 2, 0);
            if (width > oldWidth) {
                change2 = width - oldWidth + 2;
                this.header.redraw(x, 0, change2, headerBounds.height, false);
            } else {
                change2 = oldWidth - width + 2;
                this.header.redraw(headerBounds.width - change2, 0, change2, headerBounds.height, false);
            }
        }
        column.width = width;
        column.updateWidth(headerGC);
        headerGC.dispose();
        int i = 0;
        while (i < this.items.length) {
            this.items[i].updateColumnWidth(column, gc);
            ++i;
        }
        gc.dispose();
        int maximum = 0;
        int i2 = 0;
        while (i2 < this.columns.length) {
            maximum += this.columns[i2].width;
            ++i2;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setMaximum(Math.max(1, maximum));
            if (hBar.getThumb() != this.clientArea.width) {
                hBar.setThumb(this.clientArea.width);
                hBar.setPageIncrement(this.clientArea.width);
            }
            int oldHorizontalOffset = this.horizontalOffset;
            hBar.setVisible(this.clientArea.width < maximum);
            int selection = hBar.getSelection();
            if (selection != oldHorizontalOffset) {
                this.horizontalOffset = selection;
                this.redraw();
                if (this.drawCount <= 0 && this.header.getVisible()) {
                    this.header.redraw();
                }
            }
        }
        column.sendEvent(11);
        TreeColumn[] orderedColumns = this.getOrderedColumns();
        int i3 = column.getOrderIndex() + 1;
        while (i3 < orderedColumns.length) {
            if (!orderedColumns[i3].isDisposed()) {
                orderedColumns[i3].sendEvent(10);
            }
            ++i3;
        }
        if (this.availableItemsCount == 0) {
            this.redraw();
        }
    }

    void updateHorizontalBar() {
        int thumb;
        int i;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int maxX = 0;
        if (this.columns.length > 0) {
            i = 0;
            while (i < this.columns.length) {
                maxX += this.columns[i].width;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.availableItemsCount) {
                Rectangle itemBounds = this.availableItems[i].getCellBounds(0);
                maxX = Math.max(maxX, itemBounds.x + itemBounds.width + this.horizontalOffset);
                ++i;
            }
        }
        int clientWidth = this.clientArea.width;
        if (maxX != hBar.getMaximum()) {
            hBar.setMaximum(Math.max(1, maxX));
        }
        if ((thumb = Math.min(clientWidth, maxX)) != hBar.getThumb()) {
            hBar.setThumb(thumb);
            hBar.setPageIncrement(thumb);
        }
        hBar.setVisible(clientWidth < maxX);
        if (maxX < this.horizontalOffset + thumb) {
            this.horizontalOffset = maxX - thumb;
            hBar.setSelection(this.horizontalOffset);
            this.redraw();
        } else {
            int selection = hBar.getSelection();
            if (selection != this.horizontalOffset) {
                this.horizontalOffset = selection;
                this.redraw();
            }
        }
    }

    void updateHorizontalBar(int newRightX, int rightXchange) {
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int barMaximum = hBar.getMaximum();
        if ((newRightX += this.horizontalOffset) > barMaximum) {
            hBar.setMaximum(newRightX);
            int clientAreaWidth = this.clientArea.width;
            int thumb = Math.min(newRightX, clientAreaWidth);
            if (hBar.getThumb() != thumb) {
                hBar.setThumb(thumb);
                hBar.setPageIncrement(thumb);
            }
            hBar.setVisible(clientAreaWidth <= newRightX);
            return;
        }
        int previousRightX = newRightX - rightXchange;
        if (previousRightX != barMaximum) {
            int clientAreaWidth = this.clientArea.width;
            int thumb = Math.min(barMaximum, clientAreaWidth);
            if (hBar.getThumb() != thumb) {
                hBar.setThumb(thumb);
                hBar.setPageIncrement(thumb);
            }
            hBar.setVisible(clientAreaWidth <= barMaximum);
            return;
        }
        this.updateHorizontalBar();
    }

    void updateVerticalBar() {
        int thumb;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return;
        }
        int pageSize = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        int maximum = Math.max(1, this.availableItemsCount);
        if (maximum != vBar.getMaximum()) {
            vBar.setMaximum(maximum);
        }
        if ((thumb = Math.min(pageSize, maximum)) != vBar.getThumb()) {
            vBar.setThumb(thumb);
            vBar.setPageIncrement(thumb);
        }
        vBar.setVisible(pageSize < maximum);
        if (maximum < this.topIndex + thumb) {
            this.topIndex = maximum - thumb;
            vBar.setSelection(this.topIndex);
            this.redraw();
        } else {
            int selection = vBar.getSelection();
            if (selection != this.topIndex) {
                this.topIndex = selection;
                this.redraw();
            }
        }
    }
}

