/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhCursorInfo_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    Decorations parent;
    MenuItem cascade;
    MenuItem defaultItem;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            Menu.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            Menu.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            Menu.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.topHandle();
        if ((this.style & 2) != 0) {
            int[] nArray = new int[6];
            nArray[0] = 1006;
            nArray[2] = 1024;
            nArray[3] = 1006;
            nArray[4] = 64;
            nArray[5] = 64;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(OS.PtMenuBar(), parentHandle, args.length / 3, args);
        } else {
            this.handle = OS.PtCreateWidget(OS.PtMenu(), parentHandle, 0, null);
        }
        if (this.handle == 0) {
            Menu.error(2);
        }
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.parent.add(this);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return (OS.PtWidgetFlags(topHandle) & 0x20000) == 0;
    }

    public int getItemCount() {
        this.checkWidget();
        int count = 0;
        int child = OS.PtWidgetChildBack(this.handle);
        if (child != 0 && (this.style & 2) != 0) {
            child = OS.PtWidgetChildBack(child);
        }
        while (child != 0) {
            child = OS.PtWidgetBrotherInFront(child);
            ++count;
        }
        return count;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            Menu.error(6);
        }
        int i = 0;
        int child = OS.PtWidgetChildBack(this.handle);
        if (child != 0 && (this.style & 2) != 0) {
            child = OS.PtWidgetChildBack(child);
        }
        while (child != 0) {
            Widget widget = WidgetTable.get(child);
            if (widget != null && widget instanceof MenuItem && i++ == index) {
                return (MenuItem)widget;
            }
            child = OS.PtWidgetBrotherInFront(child);
        }
        Menu.error(6);
        return null;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int count = 0;
        int child = OS.PtWidgetChildBack(this.handle);
        if (child != 0 && (this.style & 2) != 0) {
            child = OS.PtWidgetChildBack(child);
        }
        while (child != 0) {
            child = OS.PtWidgetBrotherInFront(child);
            ++count;
        }
        MenuItem[] items = new MenuItem[count];
        int i = 0;
        int j = 0;
        child = OS.PtWidgetChildBack(this.handle);
        if (child != 0 && (this.style & 2) != 0) {
            child = OS.PtWidgetChildBack(child);
        }
        while (i < count) {
            Widget widget = WidgetTable.get(child);
            if (widget != null && widget instanceof MenuItem) {
                items[j++] = (MenuItem)widget;
            }
            ++i;
            child = OS.PtWidgetBrotherInFront(child);
        }
        if (i == j) {
            return items;
        }
        MenuItem[] newItems = new MenuItem[j];
        System.arraycopy(items, 0, newItems, 0, j);
        return newItems;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    Point getSize() {
        this.checkWidget();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(this.handle, area);
        return new Point(area.size_w, area.size_h);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.PtWidgetIsRealized(this.handle);
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 1012, windowProc, 1012);
        OS.PtAddCallback(this.handle, 1013, windowProc, 1013);
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            Menu.error(4);
        }
        int i = 0;
        int child = OS.PtWidgetChildBack(this.handle);
        if (child != 0 && (this.style & 2) != 0) {
            child = OS.PtWidgetChildBack(child);
        }
        while (child != 0) {
            Widget widget = WidgetTable.get(child);
            if (item == widget) {
                return i;
            }
            if (widget != null && widget instanceof MenuItem) {
                ++i;
            }
            child = OS.PtWidgetBrotherInFront(child);
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int Pt_CB_REALIZED(int widget, int info) {
        if ((this.style & 2) == 0) {
            Shell shell = this.getShell();
            shell.activeMenu = this;
        }
        return 0;
    }

    int Pt_CB_UNREALIZED(int widget, int info) {
        if (this.cascade != null) {
            OS.PtSetResource(this.handle, 19000, 0, 8);
            int shellHandle = this.parent.topHandle();
            OS.PtReParentWidget(this.handle, shellHandle);
        }
        this.sendEvent(23);
        Shell shell = this.getShell();
        if (shell.activeMenu == this) {
            Menu parent;
            shell.activeMenu = null;
            if (this.cascade != null && (parent = this.cascade.parent) != null && (parent.style & 2) == 0 && OS.PtWidgetIsRealized(parent.handle)) {
                shell.activeMenu = parent;
            }
        }
        return 0;
    }

    void releaseChildren(boolean destroy) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            Menu.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            Menu.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int flags = enabled ? 0 : 0x1020000;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            Menu.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (visible == OS.PtWidgetIsRealized(this.handle)) {
            return;
        }
        if (visible) {
            this.display.runDeferredEvents();
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                PhPoint_t pt = new PhPoint_t();
                pt.x = (short)this.x;
                pt.y = (short)this.y;
                if (!this.hasLocation) {
                    int ig = OS.PhInputGroup(0);
                    PhCursorInfo_t info = new PhCursorInfo_t();
                    OS.PhQueryCursor((short)ig, info);
                    pt.x = info.last_press_x;
                    pt.y = info.last_press_y;
                }
                int ptr = OS.malloc(4);
                OS.memmove(ptr, pt, 4);
                OS.PtSetResource(this.handle, 1007, ptr, 0);
                OS.free(ptr);
                OS.PtRealizeWidget(this.handle);
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.PtUnrealizeWidget(this.handle);
        }
    }
}

