/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PtFileSelectionInfo_t;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int parentHandle = 0;
        if (this.parent != null && OS.PtWidgetIsRealized(this.parent.shellHandle)) {
            parentHandle = this.parent.shellHandle;
        }
        byte[] title = null;
        if (this.title != null) {
            title = Converter.wcsToMbcs(null, this.title, true);
        }
        byte[] root_dir = null;
        if (this.filterPath != null) {
            root_dir = Converter.wcsToMbcs(null, this.filterPath, true);
        }
        byte[] file_spec = null;
        int flags = 24832;
        PtFileSelectionInfo_t info = new PtFileSelectionInfo_t();
        OS.PtFileSelection(parentHandle, null, title, root_dir, file_spec, null, null, null, info, flags);
        if (info.ret == 2) {
            return null;
        }
        int length = 0;
        while (length < info.path.length && info.path[length] != 0) {
            ++length;
        }
        byte[] path = new byte[length];
        System.arraycopy(info.path, 0, path, 0, length);
        this.filterPath = new String(Converter.mbcsToWcs(null, path));
        return this.filterPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

