/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, Canvas.checkStyle(style));
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    int Pt_CB_GOT_FOCUS(int widget, int info) {
        int result = super.Pt_CB_GOT_FOCUS(widget, info);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    int Pt_CB_LOST_FOCUS(int widget, int info) {
        int result = super.Pt_CB_LOST_FOCUS(widget, info);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        this.checkWidget();
        if (gc == null) {
            Canvas.error(4);
        }
        if (gc.isDisposed()) {
            Canvas.error(5);
        }
        super.drawBackground(gc, x, y, width, height);
    }

    int drawProc(int widget, int damage) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.drawProc(widget, damage);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void redraw() {
        boolean isFocus;
        this.checkWidget();
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redraw();
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        this.checkWidget();
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redraw(x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        GC gc = new GC(this);
        gc.copyArea(x, y, width, height, destX, destY);
        gc.dispose();
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        boolean isFocus;
        this.checkWidget();
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.isFocusControl()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    Canvas.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            Canvas.error(5);
        }
        this.ime = ime;
    }
}

