/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.launching.AbstractPDELaunchConfiguration;
import org.osgi.framework.Version;

public class EclipseApplicationLaunchConfiguration
extends AbstractPDELaunchConfiguration {
    private Map fAllBundles;
    private Map fModels;
    private String fWorkspaceLocation;

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("useProduct", false)) {
            String product = configuration.getAttribute("product", "");
            if (product.length() > 0) {
                programArgs.add("-product");
                programArgs.add(product);
            } else {
                programArgs.add("-application");
                programArgs.add(configuration.getAttribute("application", ""));
            }
        } else {
            programArgs.add("-application");
            programArgs.add(configuration.getAttribute("application", TargetPlatform.getDefaultApplication()));
        }
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (this.fWorkspaceLocation.length() > 0) {
            programArgs.add("-data");
            programArgs.add(this.fWorkspaceLocation);
        }
        boolean showSplash = true;
        if (configuration.getAttribute("usefeatures", false)) {
            this.validateFeatures();
            IPath installPath = PDELaunchingPlugin.getWorkspace().getRoot().getLocation();
            programArgs.add("-install");
            programArgs.add("file:" + installPath.removeLastSegments(1).addTrailingSeparator().toString());
            if (!configuration.getAttribute("useDefaultConfigArea", true)) {
                programArgs.add("-configuration");
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
            }
            programArgs.add("-update");
            programArgs.add("-dev");
            programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties"), (boolean)true));
        } else {
            String productID = LaunchConfigurationHelper.getProductID(configuration);
            Properties prop = LaunchConfigurationHelper.createConfigIniFile(configuration, productID, this.fAllBundles, this.fModels, this.getConfigDir(configuration));
            showSplash = prop.containsKey("osgi.splashPath") || prop.containsKey("splashLocation");
            String brandingId = LaunchConfigurationHelper.getContributingPlugin(productID);
            TargetPlatform.createPlatformConfiguration((File)this.getConfigDir(configuration), (IPluginModelBase[])this.fAllBundles.values().toArray(new IPluginModelBase[this.fAllBundles.size()]), brandingId != null ? (IPluginModelBase)this.fAllBundles.get(brandingId) : null);
            TargetPlatformHelper.checkPluginPropertiesConsistency((Map)this.fAllBundles, (File)this.getConfigDir(configuration));
            programArgs.add("-configuration");
            programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
            programArgs.add("-dev");
            programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties"), (Map)this.fAllBundles));
        }
        IPluginModelBase base = (IPluginModelBase)this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) < 0) {
            programArgs.add("-pdelaunch");
        }
        String[] args = super.getProgramArguments(configuration);
        int i = 0;
        while (i < args.length) {
            programArgs.add(args[i]);
            ++i;
        }
        if (!programArgs.contains("-nosplash") && showSplash) {
            if (TargetPlatformHelper.getTargetVersion() >= 3.1) {
                programArgs.add(0, "-launcher");
                IPath path = null;
                if (TargetPlatform.getOS().equals("macosx")) {
                    path = new Path(TargetPlatform.getLocation()).append("Eclipse.app/Contents/MacOS/eclipse");
                } else {
                    path = new Path(TargetPlatform.getLocation()).append("eclipse");
                    if (TargetPlatform.getOS().equals("win32")) {
                        path = path.addFileExtension("exe");
                    }
                }
                programArgs.add(1, path.toOSString());
                programArgs.add(2, "-name");
                programArgs.add(3, "Eclipse");
                programArgs.add(4, "-showsplash");
                programArgs.add(5, "600");
            } else {
                programArgs.add(0, "-showsplash");
                programArgs.add(1, this.computeShowsplashArgument());
            }
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private void validateFeatures() throws CoreException {
        boolean badStructure;
        IPath installPath = PDELaunchingPlugin.getWorkspace().getRoot().getLocation();
        String lastSegment = installPath.lastSegment();
        boolean bl = badStructure = lastSegment == null;
        if (!badStructure) {
            IPath featuresPath = installPath.removeLastSegments(1).append("features");
            boolean bl2 = badStructure = !lastSegment.equalsIgnoreCase("plugins") || !featuresPath.toFile().exists();
        }
        if (badStructure) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEMessages.WorkbenchLauncherConfigurationDelegate_badFeatureSetup));
        }
        this.ensureProductFilesExist(this.getProductPath());
    }

    private IPath getProductPath() {
        return PDELaunchingPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1);
    }

    private String computeShowsplashArgument() {
        Path eclipseHome = new Path(TargetPlatform.getLocation());
        IPath fullPath = eclipseHome.append("eclipse");
        return String.valueOf(fullPath.toOSString()) + " -showsplash 600";
    }

    private void ensureProductFilesExist(IPath productArea) {
        File ini;
        File configDir;
        File productDir = productArea.toFile();
        File marker = new File(productDir, ".eclipseproduct");
        Path eclipsePath = new Path(TargetPlatform.getLocation());
        if (!marker.exists()) {
            CoreUtility.copyFile((IPath)eclipsePath, (String)".eclipseproduct", (File)marker);
        }
        if (!(configDir = new File(productDir, "configuration")).exists()) {
            configDir.mkdirs();
        }
        if (!(ini = new File(configDir, "config.ini")).exists()) {
            CoreUtility.copyFile((IPath)eclipsePath.append("configuration"), (String)"config.ini", (File)ini);
        }
    }

    protected File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            try {
                if (config.getAttribute("usefeatures", false) && config.getAttribute("useDefaultConfigArea", true)) {
                    String root = this.getProductPath().toString();
                    root = String.valueOf(root) + "/configuration";
                    this.fConfigDir = new File(root);
                    if (!this.fConfigDir.exists()) {
                        this.fConfigDir.mkdirs();
                    }
                } else {
                    this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(config);
                }
            }
            catch (CoreException coreException) {
                this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(config);
            }
        }
        return this.fConfigDir;
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        }
        if (!LauncherUtils.clearWorkspace(configuration, this.fWorkspaceLocation, monitor)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigDir(configuration));
        }
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fWorkspaceLocation = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap(configuration, false);
        this.fAllBundles = new HashMap(this.fModels.size());
        Iterator iter = this.fModels.keySet().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            this.fAllBundles.put(model.getPluginBase().getId(), model);
        }
        this.validateConfigIni(configuration);
        super.preLaunchCheck(configuration, launch, monitor);
    }

    private void validateConfigIni(ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.getAttribute("useDefaultConfig", true)) {
            String templateLoc = configuration.getAttribute("templateConfig", "");
            IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
            templateLoc = mgr.performStringSubstitution(templateLoc);
            File templateFile = new File(templateLoc);
            if (!templateFile.exists() && !LauncherUtils.generateConfigIni()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] vmArgs = super.getVMArguments(configuration);
        IPluginModelBase base = (IPluginModelBase)this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) >= 0) {
            String[] result = new String[vmArgs.length + 1];
            System.arraycopy(vmArgs, 0, result, 0, vmArgs.length);
            result[vmArgs.length] = "-Declipse.pde.launch=true";
            return result;
        }
        return vmArgs;
    }
}

