/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSComponentSection
extends PDESection {
    private IDSComponent fComponent;
    private IDSImplementation fImplementation;
    private FormEntry fClassEntry;
    private FormEntry fNameEntry;
    private FormEntry fActivateEntry;
    private FormEntry fDeactivateEntry;
    private FormEntry fModifiedEntry;
    private IDSModel fModel;

    public DSComponentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.initializeAttributes();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(Messages.DSSection_title);
        section.setDescription(Messages.DSSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout(3, false));
        client.setLayoutData((Object)new GridData(768));
        this.fNameEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_nameEntry, 0);
        this.fClassEntry = new FormEntry(client, toolkit, Messages.DSImplementationDetails_classEntry, Messages.DSImplementationDetails_browse, this.isEditable(), 0);
        this.fActivateEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_activateEntry, 0);
        this.fActivateEntry.getLabel().setToolTipText(Messages.DSComponentDetails_activateTooltip);
        this.fDeactivateEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_deactivateEntry, 0);
        this.fDeactivateEntry.getLabel().setToolTipText(Messages.DSComponentDetails_deactivateTooltip);
        this.fModifiedEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_modifiedEntry, 0);
        this.fModifiedEntry.getLabel().setToolTipText(Messages.DSComponentDetails_modifiedTooltip);
        this.setListeners();
        this.updateUIFields();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void initializeAttributes() {
        this.fModel = (IDSModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        this.fComponent = this.fModel.getDSComponent();
        if (this.fComponent != null) {
            this.fImplementation = this.fComponent.getImplementation();
        }
    }

    public void commit(boolean onSave) {
        this.fClassEntry.commit();
        this.fNameEntry.commit();
        this.fActivateEntry.commit();
        this.fDeactivateEntry.commit();
        this.fModifiedEntry.commit();
        super.commit(onSave);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.fComponent = this.fModel.getDSComponent();
        if (this.fComponent != null) {
            this.fImplementation = this.fComponent.getImplementation();
        }
        if (e.getChangeType() == 99) {
            this.markStale();
        }
        if (this.fNameEntry != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DSComponentSection.this.updateUIFields();
                }
            });
        }
    }

    public void updateUIFields() {
        if (this.fComponent != null) {
            if (this.fComponent.getAttributeName() == null) {
                this.fNameEntry.setValue("", true);
            } else {
                this.fNameEntry.setValue(this.fComponent.getAttributeName(), true);
            }
            this.fNameEntry.setEditable(this.isEditable());
            if (this.fComponent.getActivateMethod() == null) {
                this.fActivateEntry.setValue("", true);
            } else {
                this.fActivateEntry.setValue(this.fComponent.getActivateMethod(), true);
            }
            this.fActivateEntry.setEditable(this.isEditable());
            if (this.fComponent.getDeactivateMethod() == null) {
                this.fDeactivateEntry.setValue("", true);
            } else {
                this.fDeactivateEntry.setValue(this.fComponent.getDeactivateMethod(), true);
            }
            this.fDeactivateEntry.setEditable(this.isEditable());
            if (this.fComponent.getModifiedMethod() == null) {
                this.fModifiedEntry.setValue("", true);
            } else {
                this.fModifiedEntry.setValue(this.fComponent.getModifiedMethod(), true);
            }
            this.fModifiedEntry.setEditable(this.isEditable());
        }
        if (this.fImplementation != null) {
            if (this.fImplementation.getClassName() == null) {
                this.fClassEntry.setValue("", true);
            } else {
                this.fClassEntry.setValue(this.fImplementation.getClassName(), true);
            }
            this.fClassEntry.setEditable(this.isEditable());
        }
    }

    public void setListeners() {
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSComponentSection.this.fComponent == null) {
                    return;
                }
                DSComponentSection.this.fComponent.setAttributeName(DSComponentSection.this.fNameEntry.getValue());
            }
        });
        this.fActivateEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSComponentSection.this.fComponent == null) {
                    return;
                }
                DSComponentSection.this.fComponent.setActivateMethod(DSComponentSection.this.fActivateEntry.getValue());
            }
        });
        this.fDeactivateEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSComponentSection.this.fComponent == null) {
                    return;
                }
                DSComponentSection.this.fComponent.setDeactivateMethod(DSComponentSection.this.fDeactivateEntry.getValue());
            }
        });
        this.fModifiedEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSComponentSection.this.fComponent == null) {
                    return;
                }
                DSComponentSection.this.fComponent.setModifiedeMethod(DSComponentSection.this.fModifiedEntry.getValue());
            }
        });
        IActionBars actionBars = this.getPage().getEditor().getEditorSite().getActionBars();
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (DSComponentSection.this.fImplementation == null) {
                    if (DSComponentSection.this.fComponent != null) {
                        DSComponentSection.this.fImplementation = DSComponentSection.this.fComponent.getModel().getFactory().createImplementation();
                        DSComponentSection.this.fImplementation.setClassName(DSComponentSection.this.fClassEntry.getValue());
                        DSComponentSection.this.fComponent.addChildNode((IDocumentElementNode)DSComponentSection.this.fImplementation, 0, true);
                    }
                } else {
                    DSComponentSection.this.fImplementation.setClassName(DSComponentSection.this.fClassEntry.getValue());
                }
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = DSComponentSection.this.fClassEntry.getValue();
                if ((value = DSComponentSection.this.handleLinkActivated(value, false)) != null) {
                    DSComponentSection.this.fClassEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                DSComponentSection.this.doOpenSelectionDialog(DSComponentSection.this.fClassEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private void doOpenSelectionDialog(FormEntry entry) {
        String filter = entry.getValue();
        filter = filter.length() == 0 ? "**" : filter.substring(filter.lastIndexOf(".") + 1);
        String type = PDEJavaHelperUI.selectType((IResource)this.fModel.getUnderlyingResource(), (int)2, (String)filter, null);
        if (type != null) {
            entry.setValue(type);
            entry.commit();
        }
    }
}

