/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.web;

import java.io.IOException;
import java.util.Map;
import javax.naming.Context;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.Module;

public class WebExecutor
extends AbstractScriptExecutor {
    private static final Logger logger = Logger.getLogger(WebExecutor.class);
    private IRepository repository;
    private String[] rootPaths;

    public WebExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        logger.debug("entering: executeServiceModule()");
        logger.debug("module=" + module);
        if (module == null) {
            throw new IOException("Web module cannot be null");
        }
        Module scriptingModule = this.retrieveModule(this.repository, module, null, this.rootPaths);
        byte[] result = scriptingModule.getContent();
        result = this.preprocessContent(result, (IEntity)this.getResource(this.repository, scriptingModule.getPath()));
        response.getWriter().print(new String(result, ICommonConstants.UTF8));
        response.getWriter().flush();
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return rawContent;
    }

    protected byte[] buildResourceData(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] data = null;
        data = this.readResourceData((IResource)entity);
        return data;
    }

    protected byte[] readResourceData(IResource resource) throws IOException {
        return resource.getContent();
    }

    protected void beforeExecution(HttpServletRequest request, HttpServletResponse response, String module, Context context) {
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
    }

    protected String getModuleType(String path) {
        return "WebContent";
    }
}

