/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.ws;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.ws.WebSocketRequestParser;
import org.eclipse.dirigible.runtime.ws.WebSocketServiceBridgeServletInternal;

public class WebSocketServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = -9115022531455267478L;
    private static final Logger logger = Logger.getLogger(WebSocketServiceServlet.class);
    private static WebSocketServiceBridgeServletInternal webSocketServiceBridgeServletInternal;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.setupDebugChannel();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setupDebugChannel() throws IOException {
        logger.debug("Setting Service channel internal ...");
        webSocketServiceBridgeServletInternal = new WebSocketServiceBridgeServletInternal();
        DirigibleBridge.BRIDGES.put("websocket_service_channel_internal", webSocketServiceBridgeServletInternal);
        logger.debug("Service channel internal has been set.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String json = WebSocketRequestParser.gson.toJsonTree(WebSocketServiceBridgeServletInternal.openSessions).getAsString();
        resp.setContentType("application/json");
        resp.getWriter().print(json);
        resp.getWriter().flush();
        resp.getWriter().close();
    }
}

