/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.IExecutionService;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;

public class ExecutionService
implements IExecutionService {
    private static final Logger logger = Logger.getLogger(ExecutionService.class);

    @Override
    public Object execute(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, String serviceType) {
        try {
            Set<String> types = EngineUtils.getAliases();
            for (String type : types) {
                if (type == null || !type.equalsIgnoreCase(serviceType)) continue;
                IScriptExecutor scriptExecutor = EngineUtils.createExecutorByAlias(type, request);
                return scriptExecutor.executeServiceModule(request, response, module, executionContext);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Map createContext() {
        HashMap executionContext = new HashMap();
        return executionContext;
    }
}

