/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutorProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EngineUtilsFactoryOSGi {
    private static final Logger logger = Logger.getLogger(EngineUtilsFactoryOSGi.class);
    private static Map<String, IScriptExecutorProvider> scriptExecutorProviders = Collections.synchronizedMap(new HashMap());
    private static Map<String, IScriptExecutorProvider> scriptExecutorProvidersByAlias = Collections.synchronizedMap(new HashMap());

    static {
        try {
            BundleContext context = RuntimeActivator.getContext();
            Collection serviceReferences = context.getServiceReferences(IScriptExecutorProvider.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                IScriptExecutorProvider scriptExecutorProvider = (IScriptExecutorProvider)context.getService(serviceReference);
                scriptExecutorProviders.put(scriptExecutorProvider.getType(), scriptExecutorProvider);
                scriptExecutorProvidersByAlias.put(scriptExecutorProvider.getAlias(), scriptExecutorProvider);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Set<String> getTypes() {
        return scriptExecutorProviders.keySet();
    }

    public static Set<String> getAliases() {
        return scriptExecutorProvidersByAlias.keySet();
    }

    public static IScriptExecutor createExecutor(String type, HttpServletRequest request) throws IOException {
        IScriptExecutorProvider scriptExecutorProvider = scriptExecutorProviders.get(type);
        IScriptExecutor scriptExecutor = scriptExecutorProvider.createExecutor(request);
        return scriptExecutor;
    }

    public static IScriptExecutor createExecutorByAlias(String alias, HttpServletRequest request) throws IOException {
        IScriptExecutorProvider scriptExecutorProvider = scriptExecutorProvidersByAlias.get(alias);
        IScriptExecutor scriptExecutor = scriptExecutorProvider.createExecutor(request);
        return scriptExecutor;
    }
}

