/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting;

import java.util.Collection;
import java.util.Map;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.eclipse.dirigible.runtime.scripting.IBaseScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IContextService;
import org.eclipse.dirigible.runtime.scripting.InjectedAPIBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CustomInjectedObjectsFactoryOSGi {
    private static final Logger logger = Logger.getLogger(CustomInjectedObjectsFactoryOSGi.class);

    public static void registerCustomObjects(IBaseScriptExecutor executor, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            BundleContext context = RuntimeActivator.getContext();
            if (context != null) {
                Collection serviceReferences = context.getServiceReferences(IContextService.class, null);
                for (ServiceReference serviceReference : serviceReferences) {
                    try {
                        IContextService contextService = (IContextService)context.getService(serviceReference);
                        executor.registerDefaultVariableInContextAndScope(executionContext, scope, contextService.getName(), contextService.getInstance());
                        apiBuilder.set(contextService.getName(), contextService.getInstance());
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

