/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.mail;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.utils.EnvUtils;
import org.eclipse.dirigible.runtime.mail.MailSenderProvidedService;
import org.eclipse.dirigible.runtime.mail.MailSenderService;
import org.eclipse.dirigible.runtime.scripting.IMailService;

public class MailServiceFactory {
    public static final String DEFAULT_MAIL_SERVICE = "mailSender";
    public static final String DEFAULT_MAIL_SERVICE_PROVIDED = "provided";
    public static final String DEFAULT_MAIL_SERVICE_BUILTIN = "built-in";

    public static IMailService createMailService(HttpServletRequest request) {
        IMailService mailService = null;
        if (request != null) {
            String serviceSource = EnvUtils.getEnv((String)DEFAULT_MAIL_SERVICE);
            mailService = DEFAULT_MAIL_SERVICE_PROVIDED.equals(serviceSource) ? new MailSenderProvidedService(request) : new MailSenderService(request);
        }
        return mailService;
    }
}

