/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.command.Piper;
import org.eclipse.dirigible.repository.ext.command.ProcessUtils;
import org.eclipse.dirigible.repository.ext.utils.FileUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.command.CommandData;
import org.eclipse.dirigible.runtime.command.CommandDataParser;
import org.eclipse.dirigible.runtime.command.Messages;
import org.eclipse.dirigible.runtime.filter.XSSUtils;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;

public class CommandExecutor
extends AbstractScriptExecutor {
    private static final String WORK = "work";
    private static final String COMMAND_MODULE_NAME_CANNOT_BE_NULL = Messages.getString("CommandExecutor.COMMAND_MODULE_NAME_CANNOT_BE_NULL");
    private static final Logger logger = Logger.getLogger(CommandExecutor.class);
    private IRepository repository;
    private String[] rootPaths;

    public CommandExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        ByteArrayOutputStream out;
        CommandData commandData;
        logger.debug("entering: executeServiceModule()");
        logger.debug("module=" + module);
        if (module == null) {
            throw new IOException(COMMAND_MODULE_NAME_CANNOT_BE_NULL);
        }
        String result = null;
        String commandSource = new String(this.retrieveModule(this.repository, module, "", this.rootPaths).getContent(), StandardCharsets.UTF_8);
        try {
            commandData = CommandDataParser.parseCommandData(commandSource);
        }
        catch (IllegalArgumentException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new IOException(e2);
        }
        String commandLine = commandData.getTargetCommand().getCommand();
        String[] args = null;
        try {
            args = ProcessUtils.translateCommandline((String)commandLine);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new IOException(e1);
        }
        logger.debug("executing command=" + commandLine);
        try {
            int i;
            ProcessBuilder processBuilder = ProcessUtils.createProcess((String[])args);
            ProcessUtils.addEnvironmentVariables((ProcessBuilder)processBuilder, commandData.getEnvAdd());
            ProcessUtils.removeEnvironmentVariables((ProcessBuilder)processBuilder, commandData.getEnvRemove());
            if (commandData.isUseContent()) {
                String directory;
                if (commandData.getWorkDir() == null) {
                    commandData.setWorkDir(WORK);
                }
                if ((directory = XSSUtils.stripXSS((String)commandData.getWorkDir())) == null || "".equals(directory)) {
                    directory = WORK;
                }
                File targetFolder = FileUtils.createTempDirectory((String)directory);
                i = this.rootPaths.length - 1;
                while (i >= 0) {
                    ICollection collection = this.getCollection(this.repository, this.rootPaths[i]);
                    FileUtils.copyCollectionToDirectory((ICollection)collection, (File)targetFolder, (String[])this.rootPaths);
                    --i;
                }
                processBuilder.directory(targetFolder);
            } else {
                processBuilder.directory(new File(commandData.getWorkDir()));
            }
            processBuilder.redirectErrorStream(true);
            out = new ByteArrayOutputStream();
            Process process = ProcessUtils.startProcess((String[])args, (ProcessBuilder)processBuilder);
            Piper pipe = new Piper(process.getInputStream(), (OutputStream)out);
            new Thread((Runnable)pipe).start();
            try {
                i = 0;
                boolean deadYet = false;
                do {
                    Thread.sleep(ProcessUtils.DEFAULT_WAIT_TIME);
                    try {
                        process.exitValue();
                        deadYet = true;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (++i < ProcessUtils.DEFAULT_LOOP_COUNT) continue;
                        process.destroy();
                        throw new RuntimeException("Exeeds timeout - " + ProcessUtils.DEFAULT_WAIT_TIME / 1000 * ProcessUtils.DEFAULT_LOOP_COUNT);
                    }
                } while (!deadYet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new IOException(e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
        result = new String(out.toByteArray());
        response.getWriter().write(result);
        response.getWriter().flush();
        response.getWriter().close();
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

