/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.processing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Breakpoint;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.DebuggingService;

public class BreakpointRepository {
    private static BreakpointRepository INSTANCE = new BreakpointRepository();
    private final Map<String, Set<Breakpoint>> breakpoints = new HashMap<String, Set<Breakpoint>>();

    private BreakpointRepository() {
    }

    public static synchronized BreakpointRepository getInstance() {
        return INSTANCE;
    }

    public void add(String userId, Breakpoint breakpoint) {
        Set<Breakpoint> userBreakpoints = this.getUserBreakpoints(userId);
        if (userBreakpoints == null) {
            userBreakpoints = new HashSet<Breakpoint>();
        }
        userBreakpoints.add(breakpoint);
        this.breakpoints.put(userId, userBreakpoints);
        DebuggingService.setBreakpointWithId(userId, breakpoint.getId());
    }

    public Breakpoint getById(String userId, String breakpointId) {
        Set<Breakpoint> userBreakpoints = this.getUserBreakpoints(userId);
        if (userBreakpoints == null) {
            return null;
        }
        for (Breakpoint b : userBreakpoints) {
            if (!b.getId().equals(breakpointId)) continue;
            return b;
        }
        return null;
    }

    public Map<String, Set<Breakpoint>> getBreakpoints() {
        return this.breakpoints;
    }

    public Set<Breakpoint> getUserBreakpoints(String userId) {
        return this.breakpoints.get(userId);
    }

    public void removeById(String userId, String breakpointId) {
        Set<Breakpoint> userBreakpoints = this.getUserBreakpoints(userId);
        if (userBreakpoints == null) {
            return;
        }
        Iterator<Breakpoint> iterator = userBreakpoints.iterator();
        while (iterator.hasNext()) {
            Breakpoint breakpoint = iterator.next();
            if (!breakpoint.getId().equals(breakpointId)) continue;
            iterator.remove();
        }
        DebuggingService.removeBreakpoint(userId, breakpointId);
    }

    public Set<Breakpoint> getBreakpointsForScript(String userId, String scriptId) {
        Set<Breakpoint> userBreakpoints = this.getUserBreakpoints(userId);
        HashSet<Breakpoint> result = new HashSet<Breakpoint>();
        if (scriptId == null || userBreakpoints == null) {
            return result;
        }
        for (Breakpoint b : userBreakpoints) {
            String bScriptId;
            Location location = b.getLocation();
            if (location == null || !scriptId.equals(bScriptId = location.getScriptId())) continue;
            result.add(b);
        }
        return result;
    }

    public Set<Breakpoint> getSortedBreakpointsForScript(String userId, String scriptId) {
        Set<Breakpoint> breakpointsForScript = this.getBreakpointsForScript(userId, scriptId);
        return new TreeSet<Breakpoint>(breakpointsForScript);
    }

    public List<Location> getBreakpointLocationsForScript(String userId, String scriptId) {
        Set<Breakpoint> breakpointsForScript = this.getBreakpointsForScript(userId, scriptId);
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Breakpoint b : breakpointsForScript) {
            locations.add(b.getLocation());
        }
        return locations;
    }
}

