/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitParametersInjector
implements IInjector {
    private static final String INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SERVLET_CONFIGURATION_NAME_S_VALUE_S = "Initial Parameter per Request retreived from the Servlet Configuration: name=%s value=%s";
    private static final String INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SYSTEM_ENVIRONMENT_NAME_S_VALUE_S = "Initial Parameter per Request retreived from the System Environment: name=%s value=%s";
    private static final String INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SYSTEM_PROPERTIES_NAME_S_VALUE_S = "Initial Parameter per Request retreived from the System Properties: name=%s value=%s";
    private static final String INITIAL_PARAMETER_SET_TO_THE_ENVIRONMENT_NAME_S_VALUE_S = "Initial Parameter set to the Environment: name=%s value=%s";
    private static final String INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_ENVIRONMENT_NAME_S_VALUE_S = "Initial Parameter exists in the System Environment: name=%s value=%s";
    private static final String INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_PROPERTIES_NAME_S_VALUE_S = "Initial Parameter exists in the System Properties: name=%s value=%s";
    private static final Logger logger = LoggerFactory.getLogger((String)InitParametersInjector.class.getCanonicalName());
    public static final String INIT_PARAM_RUNTIME_URL = "runtimeUrl";
    public static final String INIT_PARAM_SERVICES_URL = "servicesUrl";
    public static final String INIT_PARAM_ENABLE_ROLES = "enableRoles";
    public static final String INIT_PARAM_LOG_IN_SYSTEM_OUTPUT = "logInSystemOutput";
    public static final String INIT_PARAM_JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";
    public static final String INIT_PARAM_JNDI_CONNECTIVITY_CONFIGURATION = "jndiConnectivityService";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION = "jndiCmisService";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_AUTH = "jndiCmisServiceAuth";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_AUTH_KEY = "key";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_AUTH_DEST = "destination";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_NAME = "jndiCmisServiceName";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_KEY = "jndiCmisServiceKey";
    public static final String INIT_PARAM_JNDI_CMIS_CONFIGURATION_DESTINATION = "jndiCmisServiceDestination";
    public static final String INIT_PARAM_JNDI_MAIL_SESSION = "jndiMailService";
    public static final String INIT_PARAM_JDBC_SET_AUTO_COMMIT = "jdbcAutoCommit";
    public static final String INIT_PARAM_JDBC_MAX_CONNECTIONS_COUNT = "jdbcMaxConnectionsCount";
    public static final String INIT_PARAM_JDBC_WAIT_TIMEOUT = "jdbcWaitTimeout";
    public static final String INIT_PARAM_JDBC_WAIT_COUNT = "jdbcWaitCount";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER = "repositoryProvider";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_LOCAL = "local";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_DB = "db";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_MASTER = "repositoryProviderMaster";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_MASTER_DB = "db";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_MASTER_FILESYSTEM = "filesystem";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_MASTER_GIT = "git";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE = "defaultDataSourceType";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE_JNDI = "jndi";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE_LOCAL = "local";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE = "mailSender";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE_PROVIDED = "provided";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE_BUILTIN = "built-in";
    public static final String INIT_PARAM_HOME_URL = "homeLocation";
    public static final String INIT_PARAM_RUN_TESTS_ON_INIT = "runTestsOnInit";
    public static final String INIT_PARAM_AUTO_ACTIVATE_ENABLED = "autoActivateEnabled";
    public static final String INIT_PARAM_AUTO_PUBLISH_ENABLED = "autoPublishEnabled";
    public static final String INIT_PARAM_ENABLE_SANDBOX = "enableSandbox";
    public static final String INIT_PARAM_LOCAL_REPOSITORY_ROOT_FOLDER = "localRepositoryRootFolder";
    public static final String INIT_PARAM_LOCAL_REPOSITORY_ROOT_FOLDER_IS_ABSOLUTE = "localRepositoryRootFolderIsAbsolute";
    public static final String INIT_PARAM_RUN_ON_OSGI = "osgi";
    public static final String INIT_PARAM_LOCAL_DATABASE_ROOT_FOLDER = "localDatabaseRootFolder";
    public static final String INIT_PARAM_LOCAL_CMIS_ROOT_FOLDER = "localCmisRootFolder";
    public static final String INIT_PARAM_DEFAULT_THEME = "defaultTheme";

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = null;
            if (System.getProperties().containsKey(parameterName)) {
                parameterValue = System.getProperty(parameterName);
                logger.debug(String.format(INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SYSTEM_PROPERTIES_NAME_S_VALUE_S, parameterName, parameterValue));
            } else if (System.getenv().containsKey(parameterName)) {
                parameterValue = System.getenv().get(parameterName);
                logger.debug(String.format(INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SYSTEM_ENVIRONMENT_NAME_S_VALUE_S, parameterName, parameterValue));
            } else {
                parameterValue = servletConfig.getInitParameter(parameterName);
                logger.debug(String.format(INITIAL_PARAMETER_PER_REQUEST_RETREIVED_FROM_THE_SERVLET_CONFIGURATION_NAME_S_VALUE_S, parameterName, parameterValue));
            }
            req.setAttribute(parameterName, (Object)parameterValue);
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = null;
            if (System.getProperties().containsKey(parameterName)) {
                parameterValue = System.getProperty(parameterName);
                logger.info(String.format(INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_PROPERTIES_NAME_S_VALUE_S, parameterName, parameterValue));
                System.out.println(String.format(INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_PROPERTIES_NAME_S_VALUE_S, parameterName, parameterValue));
            }
            if (System.getenv().containsKey(parameterName)) {
                parameterValue = System.getenv().get(parameterName);
                logger.debug(String.format(INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_ENVIRONMENT_NAME_S_VALUE_S, parameterName, parameterValue));
                System.out.println(String.format(INITIAL_PARAMETER_EXISTS_IN_THE_SYSTEM_ENVIRONMENT_NAME_S_VALUE_S, parameterName, parameterValue));
                continue;
            }
            parameterValue = servletConfig.getInitParameter(parameterName);
            System.getProperties().put(parameterName, parameterValue);
            logger.info(String.format(INITIAL_PARAMETER_SET_TO_THE_ENVIRONMENT_NAME_S_VALUE_S, parameterName, parameterValue));
            System.out.println(String.format(INITIAL_PARAMETER_SET_TO_THE_ENVIRONMENT_NAME_S_VALUE_S, parameterName, parameterValue));
        }
    }

    public static String get(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return System.getenv().get(key);
    }
}

