/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.ConnectivityInjector;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisInjector
implements IInjector {
    private static final String PARAM_PASSWORD = "Password";
    private static final String PARAM_USER = "User";
    public static final String CMIS_CONFIGURATION = "CmisSession";
    private static final Logger logger = LoggerFactory.getLogger((String)CmisInjector.class.getCanonicalName());

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object cmisConfiguration = System.getProperties().get(CMIS_CONFIGURATION);
        if (cmisConfiguration == null) {
            try {
                cmisConfiguration = this.lookupCmisConfiguration();
                if (cmisConfiguration != null) {
                    req.setAttribute(CMIS_CONFIGURATION, cmisConfiguration);
                    System.getProperties().put(CMIS_CONFIGURATION, cmisConfiguration);
                } else {
                    logger.warn("jndiCmisService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Object cmisConfiguration = System.getProperties().get(CMIS_CONFIGURATION);
        if (cmisConfiguration == null) {
            try {
                cmisConfiguration = this.lookupCmisConfiguration();
                if (cmisConfiguration != null) {
                    System.getProperties().put(CMIS_CONFIGURATION, cmisConfiguration);
                } else {
                    logger.warn("jndiCmisService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    private Object lookupCmisConfiguration() throws NamingException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        InitialContext ctx = new InitialContext();
        String key = InitParametersInjector.get("jndiCmisService");
        if (key != null) {
            Object ecmService = ctx.lookup(key);
            if (ecmService != null) {
                String authMethod = InitParametersInjector.get("jndiCmisServiceAuth");
                logger.debug(String.format("CMIS Authentication Method: %s", authMethod));
                String uniqueName = null;
                String secretKey = null;
                if ("key".equals(authMethod)) {
                    uniqueName = InitParametersInjector.get("jndiCmisServiceName");
                    secretKey = InitParametersInjector.get("jndiCmisServiceKey");
                } else if ("destination".equals(authMethod)) {
                    String destinationName = InitParametersInjector.get("jndiCmisServiceDestination");
                    Properties destinationPropeties = this.initializeFromDestination(destinationName);
                    uniqueName = destinationPropeties.getProperty(PARAM_USER);
                    secretKey = destinationPropeties.getProperty(PARAM_PASSWORD);
                } else {
                    logger.error(String.format("Connection to CMIS Repository was failed. Invalid Authentication Method: %s", authMethod));
                    return null;
                }
                logger.debug("Connecting to CMIS Repository with name: %s and key: %s", (Object)uniqueName, (Object)secretKey);
                try {
                    Method connectMethod = ecmService.getClass().getMethod("connect", String.class, String.class);
                    Object openCmisSession = connectMethod.invoke(ecmService, uniqueName, secretKey);
                    if (openCmisSession != null) {
                        logger.debug("Connection to CMIS Repository was successful.");
                        return openCmisSession;
                    }
                }
                catch (Exception e) {
                    logger.error("Connection to CMIS Repository was failed.", (Throwable)e);
                }
            } else {
                logger.error("ECM Service is requested, but not available");
            }
        }
        return null;
    }

    private Properties initializeFromDestination(String destinationName) throws NamingException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.debug(String.format("CMIS Lookup Destination: %s", destinationName));
        Object connectivityService = ConnectivityInjector.lookupConnectivityConfiguration();
        Method connectivityMethod = connectivityService.getClass().getMethod("getConnectivityConfiguration", new Class[0]);
        Object configuration = connectivityMethod.invoke(connectivityService, new Object[0]);
        Method configurationMethod = configuration.getClass().getMethod("getConfiguration", String.class);
        Object destinationConfiguration = configurationMethod.invoke(configuration, destinationName);
        Method propertiesMethod = destinationConfiguration.getClass().getMethod("getAllProperties", new Class[0]);
        Properties destinationPropeties = (Properties)propertiesMethod.invoke(destinationConfiguration, new Object[0]);
        logger.debug(String.format("CMIS Destination Properties: %s", CmisInjector.getPropertiesAsString(destinationPropeties)));
        return destinationPropeties;
    }

    private static String getPropertiesAsString(Properties prop) {
        if (prop == null) {
            return "null properties";
        }
        StringWriter writer = new StringWriter();
        try {
            prop.store(writer, "");
        }
        catch (IOException e) {
            logger.error("Connection to CMIS Repository was failed.", (Throwable)e);
        }
        return writer.getBuffer().toString();
    }
}

