/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadEvent;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;

final class FileUploadTracker {
    private final FileUploadHandler handler;
    private String contentType;
    private String fileName;
    private long contentLength;
    private long bytesRead;
    private Exception exception;

    FileUploadTracker(FileUploadHandler handler) {
        this.handler = handler;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    void setFileName(String fileName) {
        this.fileName = fileName;
    }

    void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    void handleProgress() {
        new InternalFileUploadEvent(this.handler).dispatchAsProgress();
    }

    void handleFinished() {
        new InternalFileUploadEvent(this.handler).dispatchAsFinished();
    }

    void handleFailed() {
        new InternalFileUploadEvent(this.handler).dispatchAsFailed();
    }

    private final class InternalFileUploadEvent
    extends FileUploadEvent {
        private static final long serialVersionUID = 1L;

        private InternalFileUploadEvent(FileUploadHandler source) {
            super(source);
        }

        @Override
        public String getContentType() {
            return FileUploadTracker.this.contentType;
        }

        @Override
        public long getContentLength() {
            return FileUploadTracker.this.contentLength;
        }

        @Override
        public long getBytesRead() {
            return FileUploadTracker.this.bytesRead;
        }

        @Override
        public String getFileName() {
            return FileUploadTracker.this.fileName;
        }

        @Override
        public Exception getException() {
            return FileUploadTracker.this.exception;
        }

        void dispatchAsProgress() {
            super.dispatchProgress();
        }

        void dispatchAsFinished() {
            super.dispatchFinished();
        }

        void dispatchAsFailed() {
            super.dispatchFailed();
        }
    }
}

