/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import org.apache.commons.io.FileCleaningTracker;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;

class CleaningTrackerUtil {
    static final String TRACKER_ATTR = CleaningTrackerUtil.class.getName().concat("#cleaningTrackerInstance");
    private static final FileUploadCleanupHandler LISTENER = new FileUploadCleanupHandler();

    private CleaningTrackerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCleaningTracker getCleaningTracker(boolean create) {
        FileCleaningTracker tracker;
        UISession store;
        UISession uISession = store = RWT.getUISession();
        synchronized (uISession) {
            tracker = (FileCleaningTracker)store.getAttribute(TRACKER_ATTR);
            if (tracker == null && create) {
                tracker = new FileCleaningTracker();
                store.setAttribute(TRACKER_ATTR, (Object)tracker);
                store.addUISessionListener((UISessionListener)LISTENER);
            }
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopCleaningTracker(ISessionStore store) {
        ISessionStore iSessionStore = store;
        synchronized (iSessionStore) {
            FileCleaningTracker tracker = (FileCleaningTracker)store.getAttribute(TRACKER_ATTR);
            if (tracker != null) {
                tracker.exitWhenFinished();
                store.removeAttribute(TRACKER_ATTR);
            }
        }
    }

    private static class FileUploadCleanupHandler
    implements UISessionListener {
        private static final long serialVersionUID = 6254252338541638740L;

        private FileUploadCleanupHandler() {
        }

        public void beforeDestroy(UISessionEvent event) {
            CleaningTrackerUtil.stopCleaningTracker((ISessionStore)event.getUISession());
        }
    }
}

